package main

import (
	"github.com/elastic/go-elasticsearch/v7"
	"net/http"
)

type ESIndex struct {
	Index ESIndexData `json:"index"`
}

type ESIndexData struct {
	Index string `json:"_index"`
	Type string `json:"_type"`
	ID string `json:"_id"`
}

// Creates an Elasticsearch Client
// Provide esEndpoint as the endpoint to send data to, such as https://search-dylan-es-test-hsz3h7rt5nklhg7ga6gtgqdtuq.us-west-2.es.amazonaws.com
// Provide config as the Application Configuration so data like Region can be read
func setupESClient(esEndpoint string, config *Config) (*elasticsearch.Client, error) {
	esCfg := elasticsearch.Config{
		// Attach the SigV4Signer to the Transport so requests can authenticate with AWS
		Transport: &SigV4Signer{
			RoundTripper: http.DefaultTransport,
			Region: config.Region,
		},
		Addresses: []string{ esEndpoint, },
	}

	es, err := elasticsearch.NewClient(esCfg)
	return es, err
}
