package main

import (
	"bytes"
	"fmt"
	"github.com/aws/aws-sdk-go/aws/session"
	v4 "github.com/aws/aws-sdk-go/aws/signer/v4"
	"io/ioutil"
	"net/http"
	"time"
)

type SigV4Signer struct {
	RoundTripper http.RoundTripper
	Region string
}

func (s *SigV4Signer) RoundTrip(req *http.Request) (*http.Response, error) {
	sess := session.Must(session.NewSession())
	signer := v4.NewSigner(sess.Config.Credentials)

	switch req.Body {
	case nil:
		_, err := signer.Sign(req, nil, "es", s.Region, time.Now())
		if err != nil {
			return nil, fmt.Errorf("error signing request: %v", err)
		}
	default:
		b, err := ioutil.ReadAll(req.Body)
		if err != nil {
			return nil, err
		}
		req.Body.Close() // close old body

		_, err = signer.Sign(req, bytes.NewReader(b), "es", s.Region, time.Now())
		if err != nil {
			return nil, fmt.Errorf("error signing request: %v", err)
		}
		req.Body = ioutil.NopCloser(bytes.NewReader(b))
	}
	return s.RoundTripper.RoundTrip(req)
}
