variable "cloudwatch_log_group_name" {} // The Cloudwatch Log Group Name to ship to Elasticsearch
variable "lambda_name" {} // The Cloudwatch Elasticsearch Shipper Name created from the "cw_es_shipper_lambda" module

data "aws_cloudwatch_log_group" "cloudwatch_log" {
  name = "${var.cloudwatch_log_group_name}"
}

data "aws_lambda_function" "cw_es_shipper" {
  function_name = "${var.lambda_name}"
}


resource "aws_cloudwatch_log_subscription_filter" "lambda_subscription_to_cwlogs" {
  name            = "cw_es_shipper_${var.cloudwatch_log_group_name}"
  log_group_name  = "${var.cloudwatch_log_group_name}"
  filter_pattern  = ""
  destination_arn = "${data.aws_lambda_function.cw_es_shipper.arn}"
}

resource "aws_lambda_permission" "allow_cwlogs_invoke_lambda" {
  action        = "lambda:InvokeFunction"
  function_name = "${data.aws_lambda_function.cw_es_shipper.function_name}"
  principal     = "logs.us-west-2.amazonaws.com"
  source_arn    = "${data.aws_cloudwatch_log_group.cloudwatch_log.arn}"
}
