# IAM Role to be used for the Lambda
resource "aws_iam_role" "cw_es_shipper" {
  name = "cloudwatch_elasticsearch_shipper_${random_id.id.id}"

  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "Service": "lambda.amazonaws.com"
      },
      "Effect": "Allow",
      "Sid": ""
    }
  ]
}
EOF
}

# Logging Policies - allow adding logs
resource "aws_iam_policy" "lambda_logging" {
  name = "lambda_logging_${random_id.id.id}"
  path = "/"
  description = "IAM policy for logging from a lambda"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": [
        "logs:CreateLogStream",
        "logs:PutLogEvents"
      ],
      "Resource": "arn:aws:logs:*:*:*",
      "Effect": "Allow"
    }
  ]
}
EOF
}

resource "aws_iam_role_policy_attachment" "lambda_logs" {
  role = "${aws_iam_role.cw_es_shipper.name}"
  policy_arn = "${aws_iam_policy.lambda_logging.arn}"
}

# IAM Policy that allows posting to the Elasticsearch Service
resource "aws_iam_policy" "lambda_elasticsearch" {
  name = "lambda_elasticsearch_${random_id.id.id}"
  path = "/"
  description = "Allows Lambda to post to Elasticsearch"

  policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Action": [
                "es:ESHttpPost"
            ],
            "Effect": "Allow",
            "Resource": "${var.elasticsearch_arn}/*"
        }
    ]
}
EOF
}

resource "aws_iam_role_policy_attachment" "lambda_elasticsearch" {
  role = "${aws_iam_role.cw_es_shipper.name}"
  policy_arn = "${aws_iam_policy.lambda_elasticsearch.arn}"
}

output "lambda_iam_role_arn" {
  value = "${aws_iam_role.cw_es_shipper.arn}"
}
