from collections import namedtuple

from fabric.state import env
from fabric.api import execute
from fabric.api import task
from fabric.context_managers import settings

from legionnaire.fabric import dev  # noqa

env.app_name = 'codecov'
env.app_docker_repo = 'docker-registry.internal.justin.tv/qe/dashboard-v2.codecov'  # noqa


ChangelogEnvironment = namedtuple('ChangelogEnvironment', (
    'memory_reservation',
))


def changelog_environment(environment):
    e = {
        'staging': ChangelogEnvironment(
            memory_reservation=128,
        ),
        'prod': ChangelogEnvironment(
            memory_reservation=128,
        ),
    }[environment]

    app_container_definition = {
        'memoryReservation': e.memory_reservation,
        'environment': [],
    }
    return settings(
        app_desired_count=3 if environment == 'prod' else 1,
        app_container_definition=app_container_definition,
    )


@task()
def deploy(environment, tag):
    """ deploy a docker tag to the ecs cluster
    """
    with changelog_environment(environment):
        execute(dev.deploy, environment=environment, tag=tag)
