/* eslint angular/log: 0 */
/* eslint angular/json-functions: 0 */

var fs = require('fs');
var path = require('path');
var gulp = require('gulp');
var del = require('del');
var sourcemaps = require('gulp-sourcemaps');
var templateCache = require('gulp-angular-templatecache');
var filter = require('gulp-filter');
var babel = require('gulp-babel');
var uglify = require('gulp-uglify');
var concat = require('gulp-concat');
var htmlify = require('gulp-angular-htmlify');
var minifyHTML = require('gulp-minify-html');
var minifyCss = require('gulp-minify-css');
var ngAnnotate = require('gulp-ng-annotate');
var install = require("gulp-install");
var jshint = require("gulp-jshint");
var csslint = require('gulp-csslint');
var livereload = require('gulp-livereload');
var merge = require('merge-stream');
var hub = require('gulp-hub');
var shell = require('gulp-shell');
var argv = require('yargs').default('environment', 'production').argv;

var bowerConfig = JSON.parse(fs.readFileSync('bower.json', 'utf8'))
var packageConfig = JSON.parse(fs.readFileSync('package.json', 'utf8'));
var paths = {
  modules: 'app/',
  js: 'static/js/**/*.js',
  css: 'static/css/**/*.css',
  images: 'static/img/**/*.+(png|jpg|jpeg|gif|svg|ico)',
  templates: 'static/templates/**/*.html',
  // Submodules that are handling their own compilation
  blacklisted: []
};

var outputBase = 'app'
var environment = argv.environment;

// Gets folders for a given path
function getModules(dir) {
  return fs.readdirSync(dir).filter(function(file) {
    // build path and make sure not blacklisted
    subdir = path.join(dir, file);
    if (paths.blacklisted.indexOf(subdir) != -1) {
      return false;
    }

    stats = fs.statSync(subdir);
    return stats.isDirectory();
  });
}

// Gracefully ends any errors
function onError(err) {
    console.log(err);
    this.emit('end');
}

// Build the CSS for a specific module
function buildJS(moduleName) {
  // concat into moduleName.js
  // write to output
  // minify
  // rename to moduleName.min.js
  // write to output again

  var d = path.join(paths.modules, moduleName, '/', paths.js);

  return gulp.src([
      path.join(paths.modules, moduleName, '/static/dist/templates.js'),
      path.join(paths.modules, moduleName, '/', paths.js),
    ])
    .pipe(filter(['**', '!**/*.spec.js']))
    .pipe(jshint())
    .pipe(sourcemaps.init())
    .pipe(babel())
    .on('error', onError)
    .pipe(concat(moduleName + '.min.js'))
    .pipe(ngAnnotate())
    .pipe(uglify())
    .pipe(sourcemaps.write())
    .pipe(gulp.dest(path.join(paths.modules, moduleName, 'static/dist')))
    .pipe(livereload());
}

// Build the CSS for a specific module
function buildCSS(moduleName) {
  // concat into moduleName.css
  // write to output
  // minify
  // rename to moduleName.min.css
  // write to output again
  return gulp.src(path.join(paths.modules, moduleName, '/', paths.css))
    .pipe(csslint())
    .pipe(sourcemaps.init())
    .pipe(concat(moduleName + '.min.css'))
    .pipe(minifyCss())
    .pipe(sourcemaps.write())
    .pipe(gulp.dest(path.join(outputBase, moduleName, 'static/dist')))
    .pipe(livereload());
}

function buildTemplates(moduleName) {
  return gulp.src(path.join(paths.modules, moduleName, paths.templates))
      .pipe(htmlify())
      .pipe(minifyHTML({
          quotes: true
      }))
      .pipe(templateCache('templates.js', {
          standalone: true
      }))
      .pipe(gulp.dest(path.join(paths.modules, moduleName, 'static/dist')))
}

// Removes old files
gulp.task('clean_js', function(cb) {
  return del([path.join(paths.modules, dashboardName, '**/*.js')], cb);
});
gulp.task('clean_css', function(cb) {
  return del([path.join(outputBase, dashboardName, '**/*.css')], cb);
});
gulp.task('clean_images', function(cb) {
  return del([path.join(outputBase, dashboardName, '**/*.+(png|jpg|jpeg|gif|svg|ico)')], cb);
});

getModules(paths.modules).forEach(function(module) {
    gulp.task('templates:' + module, function() {
        return buildTemplates(module);
    });

    gulp.task('templates+js:' + module, ['templates:' + module], function() {
        return buildJS(module);
    });
})

gulp.task('js:vendor', function() {
  var vendorDeps = gulp.src('bower_components/*/**/*')

  getModules(paths.modules).map(function(x) {
    vendorDeps = vendorDeps.pipe(gulp.dest(path.join(outputBase, x, 'static/vendor')))
  });

  return vendorDeps;
})

gulp.task('js', ['js:vendor', 'templates'], function() {
  var modules = getModules(paths.modules);
  var tasks = modules.map(function(module) {
    return buildJS(module);
  });
  return merge(tasks);
});

gulp.task('css', function() {
  var modules = getModules(paths.modules);
  var tasks = modules.map(function(module) {
    return buildCSS(module);
  });
  return merge(tasks);
});

gulp.task('images', function() {
  var modules = getModules(paths.modules);
  var tasks = modules.map(function(module) {
    // move images from static folder to dist folder
    return gulp.src(path.join(paths.modules, module, '/', paths.images))
      .pipe(gulp.dest(path.join(paths.modules, module, 'static/img')))
      .pipe(livereload());
  });
  return merge(tasks);
});

gulp.task('templates', function() {
  return merge(getModules(paths.modules)
    .map(buildTemplates));
})

gulp.task('install', function () {
  return gulp.src(['./bower.json'])
    .pipe(install());
});

// Rerun the task when a file changes
gulp.task('watch', ['compile'], function() {
  livereload.listen();
  // Watch for a .js file change, get the folder name, and rebuild the JS in there
  gulp.watch(paths.modules + '**/' + paths.js, ['templates'])
  .on('change', function(file){
    var folderPattern = paths.modules + '(.+)/static/js';
    var re = new RegExp(folderPattern, 'g');
    var match = re.exec(file.path);
    var module = match[1];
    return buildJS(module);
  });
  // Watch for a .css file change, get the folder name, and rebuild the CSS in there
  gulp.watch(paths.modules + '**/' + paths.css)
  .on('change', function(file) {
    var folderPattern = paths.modules + '(.+)/static/css';
    var re = new RegExp(folderPattern, 'g');
    var match = re.exec(file.path);
    var module = match[1];
    return buildCSS(module);
  });
  // Move images
  gulp.watch(paths.modules + '**/' + paths.images, ['images']);
  // Build templates
  getModules(paths.modules).forEach(function(module) {
      gulp.watch(
          path.join(paths.modules, module, paths.templates),
          ['templates+js:' + module]);
  });
});

// Helpers
gulp.task('default', ['install', 'compile']);
gulp.task('clean', ['clean_js', 'clean_css', 'clean_images']);
gulp.task('compile', ['js', 'css', 'images']);

hub(['app/*/gulpfile.js', 'gulpfile.js']);
