job {
    name 'qe-dashboard-v2-codecov-build'
    using 'TEMPLATE-autobuild'
    wrappers {
      credentialsBinding {
        string 'dta_tools_deploy', 'dta_tools_deploy'
        file('COURIERD_PRIVATE_KEY', 'courierd')
        file('AWS_CONFIG_FILE', 'aws_config')
      }
    }
    scm {
        git {
            remote {
                github 'qe/dashboard-v2.codecov', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
            clean true
            configure { node ->
                node / 'extensions' << 'hudson.plugins.git.extensions.impl.SubmoduleOption' {
                    recursiveSubmodules true
                    timeout 20
                }
            }
        }
    }
    steps {
        shell 'bash ./jenkins/build.sh'
        saveDeployArtifact 'qe/dashboard-v2.codecov', 'build'
    }
}

job {
    name "qe-dashboard-v2-codecov-deploy"
    parameters {
        stringParam 'GIT_COMMIT'
    }
    steps {
      shell 'echo "must deploy with an environment" && exit 1'
    }
}

['staging', 'prod'].each{ environment ->
    job {
        name "qe-dashboard-v2-codecov-deploy-${environment}"
        parameters {
            stringParam 'GIT_COMMIT'
        }
        wrappers {
            preBuildCleanup()
            timestamps()
            credentialsBinding {
                string 'AWS_SECRET_ACCESS_KEY', 'geoffcha_dashboard_aws_secret_access_key'
                string 'AWS_ACCESS_KEY_ID', 'geoffcha_dashboard_aws_access_id'
                string 'dta_tools_deploy', 'dta_tools_deploy'
                file('COURIERD_PRIVATE_KEY', 'courierd')
                file('AWS_CONFIG_FILE', 'aws_config')
            }
            environmentVariables {
                env('ENVIRONMENT', environment)
            }
        }
        steps {
            downloadDeployArtifact 'qe/dashboard-v2.codecov'
            shell 'bash ./jenkins/deploy.sh'
        }
    }
}
