#!/bin/bash
set -eo pipefail

source ./jenkins/env.sh

mkdir -p $BUILD_OUT

cp -r requirements-fabric.txt fabfile.py jenkins $BUILD_OUT

# node dependencies
docker run --rm \
  -v $(pwd):/target \
  -w /target \
  node:8 bash -c "
npm i && \
  npm run build:install && \
  npm run build
"

docker build -t $DOCKER_REPO:$DOCKER_TAG .
[[ $DOCKER_TAG != "local" ]] && \
  docker push $DOCKER_REPO:$DOCKER_TAG
