#!/bin/bash
set -eo pipefail

[[ -z "$ENVIRONMENT" ]] && echo '$ENVIRONMENT is required' && exit 1

source ./jenkins/env.sh

docker run --rm \
  -e AWS_SECRET_ACCESS_KEY \
  -e AWS_ACCESS_KEY_ID \
  -e PIP_INDEX_URL="https://pypi.internal.justin.tv/simple" \
  -v $(pwd):/target \
  -w /target \
  python:2.7 bash -c "
pip install -r requirements-fabric.txt && \
  fab deploy:$ENVIRONMENT,$DOCKER_TAG
"
