angular.module('codecov.services', [])
  .factory('CodecovApi', ['$http', '$rootScope', function($http, $rootScope) {
    var omlServiceURL = 'https://oml-staging.internal.justin.tv';
    // var omlServiceURL = 'https://5538cac9.ngrok.io'; // Luke's staging server
    var metricsURL = omlServiceURL + '/metrics',
      reposURL = omlServiceURL + '/repos',
      teamsURL = omlServiceURL + '/org',
      loading = 'api:events:loading',
      success = 'api:events:success',
      team_map = {},
      team_coverage_map_current = [],
      team_coverage_map_comparison = [],
      team_coverage_map_consolidated = [],
      repo_map = {},
      repo_coverage_map_current = [],
      repo_coverage_map_comparison = [],
      repo_coverage_map_comsolidated = [];
    return {
      fetchTeams: function() {
        $http.get(teamsURL)
          .success(function(data, status, headers, config) {
            var record;
            for (record in data) {
              team_map[data[record].oml_team_id] = data[record].oml_team_name;
            }
            console.log("Generated team_map");
          })
          .error(function(data, status, headers, config) {
            var errorMessage = "Unable to fetch data from " + teamsURL;
            $rootScope.errorOnPage = true;
            $rootScope.label_error = errorMessage;
            console.log(errorMessage);
          });
      },
      fetchRepos: function() {
        $http.get(reposURL)
          .success(function(data, status, headers, config) {
            var record;
            for (record in data) {
              repo_map[data[record].id] = data[record].name;
            }
            console.log("Generated repo_map");
          })
          .error(function(data, status, headers, config) {
            var errorMessage = "Unable to fetch data from " + reposURL;
            $rootScope.errorOnPage = true;
            $rootScope.label_error = errorMessage;
            console.log(errorMessage);
          });
      },
      fetchCurrentData: function(filters, invertOrder) {
        $http.get(metricsURL, {
            params: filters
          })
          .success(function(data, status, headers, config) {
            var record;
            for (record in data) {
              if (data[record].ghe_repo_id != null) {
                repo_coverage_map_current.push({
                  "Name": repo_map[data[record].ghe_repo_id],
                  "TeamID": data[record].oml_team_id,
                  "Coverage": data[record].computed_value
                });
              } else if (data[record].oml_team_id != null) {
                team_coverage_map_current.push({
                  "Name": team_map[data[record].oml_team_id],
                  "TeamID": data[record].oml_team_id,
                  "Coverage": data[record].computed_value,
                  "ShowRepo": true
                });
              }
            }
            team_coverage_map_current.sort(function(a, b) {
              if (invertOrder) {
                return b.Coverage - a.Coverage;
              } else {
                return a.Coverage - b.Coverage;
              }
            });
            console.log("Generated team_coverage_map_current");
            console.log("Generated repo_coverage_map_current");
            team_coverage_map_current.sort(function(a, b) {
              if (invertOrder) {
                return b.Coverage - a.Coverage;
              } else {
                return a.Coverage - b.Coverage;
              }
            });
            $rootScope.viewRepo = true;
            $rootScope.invertOrder = invertOrder;
            $rootScope.team_coverage_map_current = team_coverage_map_current;
            $rootScope.team_coverage_map_current_size = Object.keys(team_coverage_map_current).length;
            $rootScope.repo_coverage_map_current = repo_coverage_map_current;
            $rootScope.repo_coverage_map_current_size = Object.keys(repo_coverage_map_current).length;
            console.log("Generated view: Number of Teams = " + $rootScope.team_coverage_map_current_size);
          })
          .error(function(data, status, headers, config) {
            var errorMessage = "Unable to fetch data from " + metricsURL;
            $rootScope.errorOnPage = true;
            $rootScope.label_error = errorMessage;
            console.log(errorMessage);
          });
      },
      displayData: function(invertOrder) {
        team_coverage_map_current.sort(function(a, b) {
          if (invertOrder) {
            return b.Coverage - a.Coverage;
          } else {
            return a.Coverage - b.Coverage;
          }
        });
        $rootScope.viewRepo = true;
        $rootScope.invertOrder = invertOrder;
        $rootScope.team_coverage_map_current = team_coverage_map_current;
        $rootScope.team_coverage_map_current_size = Object.keys(team_coverage_map_current).length;
        $rootScope.repo_coverage_map_current = repo_coverage_map_current;
        $rootScope.repo_coverage_map_current_size = Object.keys(repo_coverage_map_current).length;
      }
    };
  }]);
