angular.module('omlet.controllers', [])
  .controller('InputController', ['$scope', 'OmletApi', function($scope, OmletApi) {

    // // template
    // 'Name': [
    // {
    // 'Date': '',
    // 'OML Level': '',
    // '% of Svcs w/in SLA': '',
    // '% RIs w/in SLA': '',
    // '% Bugs w/in SLA': '',
    // '% Deploys w/ Canary': '',
    // '% Code Coverage': '',
    // '% Hosts w/ CM': '',
    // '% Svcs w/ AEC': '',
    // '% Deploys w/ Int Test': '',
    // '% Builds w/ Tests': '',
    // '% Incidents w/ Alerts': ''
    // },

    var metricsForWeek1 = {
      'Twitch': [{
        'Date': '2017/11/27',
        'OML Level': '1',
        '% of Svcs w/in SLA': '101/104 (97.12%)',
        '% RIs w/in SLA': '441/496 (88.91%)',
        '% Bugs w/in SLA': '624/668 (93.41%)',
        '% Deploys w/ Canary': '52/224 (23.21%)',
        '% Code Coverage': '191725/333945 (57.41%)',
        '% Hosts w/ CM': '10112/17851 (56.65%)',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': '1387/5353 (25.91%)',
        '% Incidents w/ Alerts': '30/77 (38.96%)'
      }],
      'Broadcaster Success': [{
        'Date': '11/27/2017',
        'OML Level': '0',
        '% of Svcs w/in SLA': '30/31 (96.77%)',
        '% RIs w/in SLA': '138/165 (83.64%)',
        '% Bugs w/in SLA': '350/367 (95.37%)',
        '% Deploys w/ Canary': '0/14 (0.00%)',
        '% Code Coverage': '29568/52723 (56.08%)',
        '% Hosts w/ CM': '6197/10411 (59.52%)',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': '177/1617 (10.95%)',
        '% Incidents w/ Alerts': '17/36 (47.22%)'
      }],
      'Abuse': [{
        'Date': '11/27/2017',
        'OML Level': '4',
        '% of Svcs w/in SLA': 'N/A',
        '% RIs w/in SLA': '7/8 (87.50%)',
        '% Bugs w/in SLA': '0/0 (100.00%)',
        '% Deploys w/ Canary': '0/0 (100.00%)',
        '% Code Coverage': 'N/A',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': 'N/A',
        '% Incidents w/ Alerts': 'N/A'
      }],
      'CAPE': [{
        'Date': '11/27/2017',
        'OML Level': '0',
        '% of Svcs w/in SLA': '28/28 (100.00%)',
        '% RIs w/in SLA': '175/193 (90.67%)',
        '% Bugs w/in SLA': '128/141 (90.78%)',
        '% Deploys w/ Canary': '0/6 (0.00%)',
        '% Code Coverage': '90474/141885 (63.77%)',
        '% Hosts w/ CM': '2345/3753 (62.48%)',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': '244/828 (29.47%)',
        '% Incidents w/ Alerts': '3/12 (25.00%)'
      }],
      'Admin Services': [{
        'Date': '11/27/2017',
        'OML Level': '0',
        '% of Svcs w/in SLA': 'N/A',
        '% RIs w/in SLA': '5/7 (71.43%)',
        '% Bugs w/in SLA': '3/3 (100.00%)',
        '% Deploys w/ Canary': '0/0 (100.00%)',
        '% Code Coverage': 'N/A',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': '0/6 (0.00%)',
        '% Incidents w/ Alerts': '1/1 (100.00%)'
      }],
      'Commerce': [{
        'Date': '11/27/2017',
        'OML Level': '0',
        '% of Svcs w/in SLA': '4/4 (100.00%)',
        '% RIs w/in SLA': '4/6 (66.67%)',
        '% Bugs w/in SLA': '47/57 (82.46%)',
        '% Deploys w/ Canary': '0/9 (0.00%)',
        '% Code Coverage': '8375/15050 (55.65%)',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': '24/68 (35.29%)',
        '% Incidents w/ Alerts': '0/1 (0.00%)'
      }],
      'Fuel': [{
        'Date': '11/27/2017',
        'OML Level': '0',
        '% of Svcs w/in SLA': 'N/A',
        '% RIs w/in SLA': '3/5 (60.00%)',
        '% Bugs w/in SLA': '6/7 (85.71%)',
        '% Deploys w/ Canary': '0/0 (100.00%)',
        '% Code Coverage': 'N/A',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': '0/3 (0.00%)',
        '% Incidents w/ Alerts': 'N/A'
      }],
      'Community': [{
        'Date': '11/27/2017',
        'OML Level': '0',
        '% of Svcs w/in SLA': '13/13 (100.00%)',
        '% RIs w/in SLA': '24/25 (96.00%)',
        '% Bugs w/in SLA': '77/83 (92.77%)',
        '% Deploys w/ Canary': '4/18 (22.22%)',
        '% Code Coverage': '28863/64478 (44.76%)',
        '% Hosts w/ CM': '636/778 (81.75%)',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': '0/136 (0.00%)',
        '% Incidents w/ Alerts': '1/5 (20.00%)'
      }],
      'Channel Feed': [{
        'Date': '11/27/2017',
        'OML Level': '0',
        '% of Svcs w/in SLA': '2/2 (100.00%)',
        '% RIs w/in SLA': '2/2 (100.00%)',
        '% Bugs w/in SLA': '27/28 (96.43%)',
        '% Deploys w/ Canary': '0/0 (100.00%)',
        '% Code Coverage': 'N/A',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': '0/49 (0.00%)',
        '% Incidents w/ Alerts': '0/1 (0.00%)'
      }],
      'Content': [{
        'Date': '11/27/2017',
        'OML Level': '5',
        '% of Svcs w/in SLA': '0/0 (100.00%)',
        '% RIs w/in SLA': '0/0 (100.00%)',
        '% Bugs w/in SLA': '0/0 (100.00%)',
        '% Deploys w/ Canary': 'N/A',
        '% Code Coverage': 'N/A',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': 'N/A',
        '% Incidents w/ Alerts': 'N/A'
      }],
      'Partnerships': [{
        'Date': '11/27/2017',
        'OML Level': '5',
        '% of Svcs w/in SLA': '0/0 (100.00%)',
        '% RIs w/in SLA': '0/0 (100.00%)',
        '% Bugs w/in SLA': '0/0 (100.00%)',
        '% Deploys w/ Canary': 'N/A',
        '% Code Coverage': 'N/A',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': 'N/A',
        '% Incidents w/ Alerts': 'N/A'
      }],
      'Dev Success': [{
        'Date': '11/27/2017',
        'OML Level': '2',
        '% of Svcs w/in SLA': '29/29 (100.00%)',
        '% RIs w/in SLA': '100/107 (93.46%)',
        '% Bugs w/in SLA': '32/35 (91.43%)',
        '% Deploys w/ Canary': '1/1 (100.00%)',
        '% Code Coverage': '35949/61222 (58.72%)',
        '% Hosts w/ CM': '1852/3079 (60.15%)',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': '122/146 (83.56%)',
        '% Incidents w/ Alerts': '10/24 (41.67%)'
      }],
      'API Infra': [{
        'Date': '11/27/2017',
        'OML Level': '0',
        '% of Svcs w/in SLA': '4/4 (100.00%)',
        '% RIs w/in SLA': '15/15 (100.00%)',
        '% Bugs w/in SLA': '0/0 (100.00%)',
        '% Deploys w/ Canary': '0/0 (100.00%)',
        '% Code Coverage': '906/1199 (75.56%)',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': '0/3 (0.00%)',
        '% Incidents w/ Alerts': '2/8 (25.00%)'
      }]
    };

    var metricsForWeek2 = {
      'Twitch': [{
        'Date': '2017/11/21',
        'OML Level': '1',
        '% of Svcs w/in SLA': '101/104 (97.12%)',
        '% RIs w/in SLA': '441/496 (88.91%)',
        '% Bugs w/in SLA': '624/668 (93.41%)',
        '% Deploys w/ Canary': '52/224 (23.21%)',
        '% Code Coverage': '191725/333945 (57.41%)',
        '% Hosts w/ CM': '10112/17851 (56.65%)',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': '1387/5353 (25.91%)',
        '% Incidents w/ Alerts': '30/77 (38.96%)'
      }],
      'Broadcaster Success': [{
        'Date': '11/20/2017',
        'OML Level': '1',
        '% of Svcs w/in SLA': '28/30 (93.33%)',
        '% RIs w/in SLA': '138/165 (83.64%)',
        '% Bugs w/in SLA': '346/361 (95.84%)',
        '% Deploys w/ Canary': '7/41 (17.07%)',
        '% Code Coverage': '29499/52631 (56.05%)',
        '% Hosts w/ CM': '5457/10356 (52.69%)',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': '380/2920 (13.01%)',
        '% Incidents w/ Alerts': '16/35 (45.71%)'
      }],
      'Abuse': [{
        'Date': '11/20/2017',
        'OML Level': '0',
        '% of Svcs w/in SLA': 'N/A',
        '% RIs w/in SLA': '7/8 (87.50%)',
        '% Bugs w/in SLA': '0/0 (100.00%)',
        '% Deploys w/ Canary': '0/0 (0.00%)',
        '% Code Coverage': 'N/A',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': 'N/A',
        '% Incidents w/ Alerts': 'N/A'
      }],
      'CAPE': [{
        'Date': '11/21/2017',
        'OML Level': '0',
        '% of Svcs w/in SLA': '28/28 (100.00%)',
        '% RIs w/in SLA': '175/193 (90.67%)',
        '% Bugs w/in SLA': '126/136 (92.65%)',
        '% Deploys w/ Canary': '4/41 (9.76%)',
        '% Code Coverage': '89384/140331 (63.70%)',
        '% Hosts w/ CM': '2316/3656 (63.35%)',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': '282/1221 (23.10%)',
        '% Incidents w/ Alerts': '3/12 (25.00%)'
      }],
      'Admin Services': [{
        'Date': '11/21/2017',
        'OML Level': '0',
        '% of Svcs w/in SLA': 'N/A',
        '% RIs w/in SLA': '5/7 (71.43%)',
        '% Bugs w/in SLA': '3/3 (100.00%)',
        '% Deploys w/ Canary': '0/5 (0.00%)',
        '% Code Coverage': 'N/A',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': '0/23 (0.00%)',
        '% Incidents w/ Alerts': '1/1 (100.00%)'
      }],
      'Commerce': [{
        'Date': '11/20/2017',
        'OML Level': '0',
        '% of Svcs w/in SLA': '4/4 (100.00%)',
        '% RIs w/in SLA': '4/6 (66.67%)',
        '% Bugs w/in SLA': '45/54 (83.33%)',
        '% Deploys w/ Canary': '0/45 (0.00%)',
        '% Code Coverage': '8060/14815 (54.40%)',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': '159/255 (62.35%)',
        '% Incidents w/ Alerts': '0/1 (0.00%)'
      }],
      'Fuel': [{
        'Date': '11/20/2017',
        'OML Level': '0',
        '% of Svcs w/in SLA': 'N/A',
        '% RIs w/in SLA': '3/5 (60.00%)',
        '% Bugs w/in SLA': '5/7 (71.43%)',
        '% Deploys w/ Canary': '0/1 (0.00%)',
        '% Code Coverage': 'N/A',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': '0/3 (0.00%)',
        '% Incidents w/ Alerts': 'N/A'
      }],
      'Community': [{
        'Date': '11/20/2017',
        'OML Level': '0',
        '% of Svcs w/in SLA': '13/13 (100.00%)',
        '% RIs w/in SLA': '24/25 (96.00%)',
        '% Bugs w/in SLA': '76/82 (92.68%)',
        '% Deploys w/ Canary': '27/78 (34.62%)',
        '% Code Coverage': '28843/64949 (44.41%)',
        '% Hosts w/ CM': '631/783 (80.59%)',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': '0/326 (0.00%)',
        '% Incidents w/ Alerts': '1/5 (20.00%)'
      }],
      'Channel Feed': [{
        'Date': '11/20/2017',
        'OML Level': '0',
        '% of Svcs w/in SLA': '2/2 (100.00%)',
        '% RIs w/in SLA': '2/2 (100.00%)',
        '% Bugs w/in SLA': '27/28 (96.43%)',
        '% Deploys w/ Canary': '0/0 (0.00%)',
        '% Code Coverage': 'N/A',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': '0/43 (0.00%)',
        '% Incidents w/ Alerts': '0/1 (0.00%)'
      }],
      'Content': [{
        'Date': '11/20/2017',
        'OML Level': '0',
        '% of Svcs w/in SLA': '0/0 (100.00%)',
        '% RIs w/in SLA': '0/0 (100.00%)',
        '% Bugs w/in SLA': '0/0 (0.00%)',
        '% Deploys w/ Canary': 'N/A',
        '% Code Coverage': 'N/A',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': 'N/A',
        '% Incidents w/ Alerts': 'N/A'
      }],
      'Partnerships': [{
        'Date': '11/20/2017',
        'OML Level': '0',
        '% of Svcs w/in SLA': '0/0 (100.00%)',
        '% RIs w/in SLA': '0/0 (100.00%)',
        '% Bugs w/in SLA': '0/0 (0.00%)',
        '% Deploys w/ Canary': 'N/A',
        '% Code Coverage': 'N/A',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': 'N/A',
        '% Incidents w/ Alerts': 'N/A'
      }],
      'Dev Success': [{
        'Date': '11/20/2017',
        'OML Level': '2',
        '% of Svcs w/in SLA': '28/29 (96.55%)',
        '% RIs w/in SLA': '100/107 (93.46%)',
        '% Bugs w/in SLA': '31/35 (88.57%)',
        '% Deploys w/ Canary': '14/19 (73.68%)',
        '% Code Coverage': '35939/61219 (58.71%)',
        '% Hosts w/ CM': '1708/3056 (55.89%)',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': '566/631 (89.70%)',
        '% Incidents w/ Alerts': '10/24 (41.67%)'
      }],
      'API Infra': [{
        'Date': '11/20/2017',
        'OML Level': '0',
        '% of Svcs w/in SLA': '3/4 (75.00%)',
        '% RIs w/in SLA': '15/15 (100.00%)',
        '% Bugs w/in SLA': '0/0 (100.00%)',
        '% Deploys w/ Canary': '0/0 (0.00%)',
        '% Code Coverage': '906/1199 (75.56%)',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': '0/4 (0.00%)',
        '% Incidents w/ Alerts': '2/8 (25.00%)'
      }]
    };

    var metricsForWeek3 = {
      'Twitch': [{
        'Date': '2017/11/14',
        'OML Level': '1',
        '% of Svcs w/in SLA': '102/104 (98.08%)',
        '% RIs w/in SLA': '438/495 (88.48%)',
        '% Bugs w/in SLA': '598/636 (94.03%)',
        '% Deploys w/ Canary': '72/313 (23.00%)',
        '% Code Coverage': '184317/323749 (56.93%)',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': 'N/A',
        '% Incidents w/ Alerts': '30/76 (39.47%)'
      }],
      'Broadcaster Success': [{
        'Date': '11/13/2017',
        'OML Level': '1',
        '% of Svcs w/in SLA': '29/30 (96.67%)',
        '% RIs w/in SLA': '136/166 (81.93%)',
        '% Bugs w/in SLA': '337/346 (97.40%)',
        '% Deploys w/ Canary': '7/59 (11.86%)',
        '% Code Coverage': '25448/47033 (54.11%)',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': 'N/A',
        '% Incidents w/ Alerts': '16/35 (45.71%)'
      }],
      'Abuse': [{
        'Date': '11/13/2017',
        'OML Level': '0',
        '% of Svcs w/in SLA': 'N/A',
        '% RIs w/in SLA': '7/8 (87.50%)',
        '% Bugs w/in SLA': '0/0 (100.00%)',
        '% Deploys w/ Canary': '0/0 (0.00%)',
        '% Code Coverage': 'N/A',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': 'N/A',
        '% Incidents w/ Alerts': 'N/A'
      }],
      'CAPE': [{
        'Date': '11/13/2017',
        'OML Level': '2',
        '% of Svcs w/in SLA': '28/28 (100.00%)',
        '% RIs w/in SLA': '175/193 (90.67%)',
        '% Bugs w/in SLA': '111/123 (90.24%)',
        '% Deploys w/ Canary': '9/18 (50.00%)',
        '% Code Coverage': '86731/136806 (63.40%)',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': 'N/A',
        '% Incidents w/ Alerts': '3/12 (25.00%)'
      }],
      'Admin Services': [{
        'Date': '11/13/2017',
        'OML Level': '0',
        '% of Svcs w/in SLA': 'N/A',
        '% RIs w/in SLA': '5/7 (71.43%)',
        '% Bugs w/in SLA': '3/3 (100.00%)',
        '% Deploys w/ Canary': '0/2 (0.00%)',
        '% Code Coverage': 'N/A',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': 'N/A',
        '% Incidents w/ Alerts': '1/1 (100.00%)'
      }],
      'Commerce': [{
        'Date': '11/13/2017',
        'OML Level': '0',
        '% of Svcs w/in SLA': '4/4 (100.00%)',
        '% RIs w/in SLA': '4/6 (66.67%)',
        '% Bugs w/in SLA': '43/51 (84.31%)',
        '% Deploys w/ Canary': '0/71 (0.00%)',
        '% Code Coverage': '7953/14655 (54.27%)',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': 'N/A',
        '% Incidents w/ Alerts': '0/1 (0.00%)'
      }],
      'Fuel': [{
        'Date': '11/13/2017',
        'OML Level': '0',
        '% of Svcs w/in SLA': 'N/A',
        '% RIs w/in SLA': '3/5 (60.00%)',
        '% Bugs w/in SLA': '5/6 (83.33%)',
        '% Deploys w/ Canary': '0/7 (0.00%)',
        '% Code Coverage': 'N/A',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': 'N/A',
        '% Incidents w/ Alerts': 'N/A'
      }],
      'Community': [{
        'Date': '11/13/2017',
        'OML Level': '1',
        '% of Svcs w/in SLA': '12/13 (92.31%)',
        '% RIs w/in SLA': '24/25 (96.00%)',
        '% Bugs w/in SLA': '76/81 (93.83%)',
        '% Deploys w/ Canary': '37/113 (32.74%)',
        '% Code Coverage': '28545/64572 (44.21%)',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': 'N/A',
        '% Incidents w/ Alerts': '1/5 (20.00%)'
      }],
      'Channel Feed': [{
        'Date': '11/13/2017',
        'OML Level': '0',
        '% of Svcs w/in SLA': '2/2 (100.00%)',
        '% RIs w/in SLA': '2/2 (100.00%)',
        '% Bugs w/in SLA': '27/27 (100.00%)',
        '% Deploys w/ Canary': '0/0 (0.00%)',
        '% Code Coverage': 'N/A',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': 'N/A',
        '% Incidents w/ Alerts': '0/1 (0.00%)'
      }],
      'Content': [{
        'Date': '11/13/2017',
        'OML Level': '0',
        '% of Svcs w/in SLA': '0/0 (100.00%)',
        '% RIs w/in SLA': '0/0 (100.00%)',
        '% Bugs w/in SLA': '0/0 (0.00%)',
        '% Deploys w/ Canary': 'N/A',
        '% Code Coverage': 'N/A',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': 'N/A',
        '% Incidents w/ Alerts': 'N/A'
      }],
      'Partnerships': [{
        'Date': '11/13/2017',
        'OML Level': '0',
        '% of Svcs w/in SLA': '0/0 (100.00%)',
        '% RIs w/in SLA': '0/0 (100.00%)',
        '% Bugs w/in SLA': '0/0 (0.00%)',
        '% Deploys w/ Canary': 'N/A',
        '% Code Coverage': 'N/A',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': 'N/A',
        '% Incidents w/ Alerts': 'N/A'
      }],
      'Dev Success': [{
        'Date': '11/13/2017',
        'OML Level': '2',
        '% of Svcs w/in SLA': '29/29 (100.00%)',
        '% RIs w/in SLA': '99/105 (94.29%)',
        '% Bugs w/in SLA': '31/35 (88.57%)',
        '% Deploys w/ Canary': '19/52 (36.54%)',
        '% Code Coverage': '35640/60683 (58.73%)',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': 'N/A',
        '% Incidents w/ Alerts': '10/23 (43.48%)'
      }],
      'API Infra': [{
        'Date': '11/13/2017',
        'OML Level': '0',
        '% of Svcs w/in SLA': '4/4 (100.00%)',
        '% RIs w/in SLA': '14/15 (93.33%)',
        '% Bugs w/in SLA': '0/0 (100.00%)',
        '% Deploys w/ Canary': '0/0 (0.00%)',
        '% Code Coverage': '892/1190 (74.96%)',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': 'N/A',
        '% Incidents w/ Alerts': '2/7 (28.57%)'
      }]
    };

    var metricsForWeek4 = {
      'Twitch': [{
        'Date': '2017/11/11',
        'OML Level': '1',
        '% of Svcs w/in SLA': '93/104 (89.42%)',
        '% RIs w/in SLA': '433/494 (87.65%)',
        '% Bugs w/in SLA': '585/620 (94.35%)',
        '% Deploys w/ Canary': '69/365 (18.90%)',
        '% Code Coverage': '164254/284579 (57.72%)',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': 'N/A',
        '% Incidents w/ Alerts': '30/76 (39.47%)'
      }],
      'Broadcaster Success': [{
        'Date': '11/07/2017',
        'OML Level': '2',
        '% of Svcs w/in SLA': '27/30 (90.00%)',
        '% RIs w/in SLA': '134/165 (81.21%)',
        '% Bugs w/in SLA': '329/339 (97.05%)',
        '% Deploys w/ Canary': 'N/A',
        '% Code Coverage': '16719/31428 (53.20%)',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': 'N/A',
        '% Incidents w/ Alerts': '16/35 (45.71%)'
      }],
      'Abuse': [{
        'Date': '11/07/2017',
        'OML Level': '4',
        '% of Svcs w/in SLA': 'N/A',
        '% RIs w/in SLA': '7/8 (87.50%)',
        '% Bugs w/in SLA': '0/0 (100.00%)',
        '% Deploys w/ Canary': 'N/A',
        '% Code Coverage': 'N/A',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': 'N/A',
        '% Incidents w/ Alerts': 'N/A'
      }],
      'CAPE': [{
        'Date': '11/07/2017',
        'OML Level': '2',
        '% of Svcs w/in SLA': '26/28 (92.86%)',
        '% RIs w/in SLA': '174/193 (90.16%)',
        '% Bugs w/in SLA': '107/119 (89.92%)',
        '% Deploys w/ Canary': 'N/A',
        '% Code Coverage': '79813/123775 (64.48%)',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': 'N/A',
        '% Incidents w/ Alerts': '3/12 (25.00%)'
      }],
      'Admin Services': [{
        'Date': '11/07/2017',
        'OML Level': '3',
        '% of Svcs w/in SLA': 'N/A',
        '% RIs w/in SLA': '5/7 (71.43%)',
        '% Bugs w/in SLA': '3/3 (100.00%)',
        '% Deploys w/ Canary': 'N/A',
        '% Code Coverage': 'N/A',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': 'N/A',
        '% Incidents w/ Alerts': '1/1 (100.00%)'
      }],
      'Commerce': [{
        'Date': '11/07/2017',
        'OML Level': '0',
        '% of Svcs w/in SLA': '3/4 (75.00%)',
        '% RIs w/in SLA': '4/6 (66.67%)',
        '% Bugs w/in SLA': '42/48 (87.50%)',
        '% Deploys w/ Canary': 'N/A',
        '% Code Coverage': '7123/13379 (53.24%)',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': 'N/A',
        '% Incidents w/ Alerts': '0/1 (0.00%)'
      }],
      'Fuel': [{
        'Date': '11/07/2017',
        'OML Level': 'N/A',
        '% of Svcs w/in SLA': 'N/A',
        '% RIs w/in SLA': '3/5 (60.00%)',
        '% Bugs w/in SLA': '4/6 (66.67%)',
        '% Deploys w/ Canary': 'N/A',
        '% Code Coverage': 'N/A',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': 'N/A',
        '% Incidents w/ Alerts': 'N/A'
      }],
      'Community': [{
        'Date': '11/07/2017',
        'OML Level': '1',
        '% of Svcs w/in SLA': '11/13 (84.62%)',
        '% RIs w/in SLA': '23/25 (92.00%)',
        '% Bugs w/in SLA': '76/80 (95.00%)',
        '% Deploys w/ Canary': 'N/A',
        '% Code Coverage': '23007/52166 (44.10%)',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': 'N/A',
        '% Incidents w/ Alerts': '1/5 (20.00%)'
      }],
      'Channel Feed': [{
        'Date': '11/07/2017',
        'OML Level': '0',
        '% of Svcs w/in SLA': '2/2 (100.00%)',
        '% RIs w/in SLA': '1/2 (50.00%)',
        '% Bugs w/in SLA': '27/27 (100.00%)',
        '% Deploys w/ Canary': 'N/A',
        '% Code Coverage': 'N/A',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': 'N/A',
        '% Incidents w/ Alerts': '0/1 (0.00%)'
      }],
      'Content': [{
        'Date': '11/07/2017',
        'OML Level': '5',
        '% of Svcs w/in SLA': '0/0 (100.00%)',
        '% RIs w/in SLA': '0/0 (100.00%)',
        '% Bugs w/in SLA': 'N/A',
        '% Deploys w/ Canary': 'N/A',
        '% Code Coverage': 'N/A',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': 'N/A',
        '% Incidents w/ Alerts': 'N/A'
      }],
      'Partnerships': [{
        'Date': '11/07/2017',
        'OML Level': '5',
        '% of Svcs w/in SLA': '0/0 (100.00%)',
        '% RIs w/in SLA': '0/0 (100.00%)',
        '% Bugs w/in SLA': 'N/A',
        '% Deploys w/ Canary': 'N/A',
        '% Code Coverage': 'N/A',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': 'N/A',
        '% Incidents w/ Alerts': 'N/A'
      }],
      'Dev Success': [{
        'Date': '11/07/2017',
        'OML Level': '2',
        '% of Svcs w/in SLA': '26/29 (89.66%)',
        '% RIs w/in SLA': '98/105 (93.33%)',
        '% Bugs w/in SLA': '31/34 (91.18%)',
        '% Deploys w/ Canary': 'N/A',
        '% Code Coverage': '34282/58606 (58.50%)',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': 'N/A',
        '% Incidents w/ Alerts': '10/23 (43.48%)'
      }],
      'API Infra': [{
        'Date': '11/07/2017',
        'OML Level': '2',
        '% of Svcs w/in SLA': '4/4 (100.00%)',
        '% RIs w/in SLA': '14/15 (93.33%)',
        '% Bugs w/in SLA': '0/0 (100.00%)',
        '% Deploys w/ Canary': 'N/A',
        '% Code Coverage': 'N/A',
        '% Hosts w/ CM': 'N/A',
        '% Svcs w/ AEC': 'N/A',
        '% Deploys w/ Int Test': 'N/A',
        '% Builds w/ Tests': 'N/A',
        '% Incidents w/ Alerts': '2/7 (28.57%)'
      }]
    };

    var metrics = metricsForWeek1;

    var STR_TWITCH = 'Twitch';

    var STR_BROADCASTER_SUCCESS = 'Broadcaster Success';
    var STR_ABUSE = 'Abuse';

    var STR_CAPE = 'CAPE';
    var STR_ADMIN_SERVICES = 'Admin Services';

    var STR_COMMERCE = 'Commerce';
    var STR_FUEL = 'Fuel';

    var STR_COMMUNITY = 'Community';
    var STR_CHANNEL_FEED = 'Channel Feed';

    var STR_CONTENT = 'Content';
    var STR_PARTNERSHIPS = 'Partnerships';

    var STR_DEV_SUCCESS = 'Dev Success';
    var STR_API_INFRA = 'API Infra';

    // var isSelectedBS = false;
    // var isSelectedCape = false;

    function selectedMetric(str) {
      $scope.isSelectedBS = false;
      $scope.isSelectedCape = false;
      $scope.isSelectedCommerce = false;
      $scope.isSelectedCommunity = false;
      $scope.isSelectedContent = false;
      $scope.isSelectedDevSuccess = false;
      switch (str) {
        // case STR_BROADCASTER_SUCCESS:
        case STR_ABUSE:
          $scope.isSelectedBS = true;
          break;
          // case STR_CAPE:
        case STR_ADMIN_SERVICES:
          $scope.isSelectedCape = true;
          break;
          // case STR_COMMERCE:
        case STR_FUEL:
          $scope.isSelectedCommerce = true;
          break;
          // case STR_COMMUNITY:
        case STR_CHANNEL_FEED:
          $scope.isSelectedCommunity = true;
          break;
          // case STR_CONTENT:
        case STR_PARTNERSHIPS:
          $scope.isSelectedContent = true;
          break;
          // case STR_DEV_SUCCESS:
        case STR_API_INFRA:
          $scope.isSelectedDevSuccess = true;
          break;
        default:
      }
    }

    function showMetricsFor(str) {
      $scope.metricsForWeek1 = metricsForWeek1[str];
      $scope.metricsForWeek2 = metricsForWeek2[str];
      $scope.metricsForWeek3 = metricsForWeek3[str];
      $scope.metricsForWeek4 = metricsForWeek4[str];
      $scope.currentView = str;
      $scope.imgSrcVertical = '/omlet/static/imgs/OML_vertical_' + metricsForWeek1[str][0]['OML Level'] + '.svg';
      // $(function() {
      //   $('tr:not(":first") > td:even').each(function(index) {
      //     $(this).addClass('red-cell');
      //   });
      // });
      selectedMetric(str);
    }

    $scope.showMetricsForTwitch = function() {
      $.bbq.pushState('#rollup_id=1&name=twitch', 2);
      showMetricsFor(STR_TWITCH);
    }

    $scope.showMetricsForBroadcaster = function() {
      $.bbq.pushState('#rollup_id=2&name=BroadcasterSuccess', 2);
      showMetricsFor(STR_BROADCASTER_SUCCESS);
    }
    $scope.showMetricsForAbuse = function() {
      $.bbq.pushState('#rollup_id=3&name=Abuse', 3);
      showMetricsFor(STR_ABUSE);
    }

    $scope.showMetricsForCape = function() {
      $.bbq.pushState('#rollup_id=2&name=Cape', 2);
      showMetricsFor(STR_CAPE);
    }
    $scope.showMetricsForAdminServices = function() {
      $.bbq.pushState('#rollup_id=3&name=AdminServices', 3);
      showMetricsFor(STR_ADMIN_SERVICES);
    }

    $scope.showMetricsForCommerce = function() {
      $.bbq.pushState('#rollup_id=2&name=Commerce', 2);
      showMetricsFor(STR_COMMERCE);
    }
    $scope.showMetricsForFuel = function() {
      $.bbq.pushState('#rollup_id=3&name=Fuel', 3);
      showMetricsFor(STR_FUEL);
    }

    $scope.showMetricsForCommunity = function() {
      $.bbq.pushState('#rollup_id=2&name=Community', 2);
      showMetricsFor(STR_COMMUNITY);
    }
    $scope.showMetricsForChannelFeed = function() {
      $.bbq.pushState('#rollup_id=3&name=ChannelFeed', 3);
      showMetricsFor(STR_CHANNEL_FEED);
    }

    $scope.showMetricsForContent = function() {
      $.bbq.pushState('#rollup_id=2&name=Content', 2);
      showMetricsFor(STR_CONTENT);
    }
    $scope.showMetricsForPartnerships = function() {
      $.bbq.pushState('#rollup_id=3&name=Partnerships', 3);
      showMetricsFor(STR_PARTNERSHIPS);
    }

    $scope.showMetricsForDevSuccess = function() {
      $.bbq.pushState('#rollup_id=2&name=DevSuccess', 2);
      showMetricsFor(STR_DEV_SUCCESS);
    }
    $scope.showMetricsForAPIInfra = function() {
      $.bbq.pushState('#rollup_id=3&name=APIInfra', 3);
      showMetricsFor(STR_API_INFRA);
    }

    $scope.showTwoWeeksData = function() {
      $scope.showMetricsForTwoWeeks = true;
      $scope.showMetricsForFourWeeks = false;
    }

    $scope.showFourWeeksData = function() {
      $scope.showMetricsForTwoWeeks = false;
      $scope.showMetricsForFourWeeks = true;
    }

    // initial page load
    $scope.imgSrcHorizontalTwitch = '/omlet/static/imgs/OML_horizontal_' + metricsForWeek1['Twitch'][0]['OML Level'] + '.svg';
    $scope.imgSrcHorizontalBS = '/omlet/static/imgs/OML_horizontal_' + metricsForWeek1['Broadcaster Success'][0]['OML Level'] + '.svg';
    $scope.imgSrcHorizontalAbuse = '/omlet/static/imgs/OML_horizontal_' + metricsForWeek1['Abuse'][0]['OML Level'] + '.svg';
    $scope.imgSrcHorizontalCape = '/omlet/static/imgs/OML_horizontal_' + metricsForWeek1['CAPE'][0]['OML Level'] + '.svg';
    $scope.imgSrcHorizontalAdminServices = '/omlet/static/imgs/OML_horizontal_' + metricsForWeek1['Admin Services'][0]['OML Level'] + '.svg';
    $scope.imgSrcHorizontalCommerce = '/omlet/static/imgs/OML_horizontal_' + metricsForWeek1['Commerce'][0]['OML Level'] + '.svg';
    $scope.imgSrcHorizontalFuel = '/omlet/static/imgs/OML_horizontal_' + metricsForWeek1['Fuel'][0]['OML Level'] + '.svg';
    $scope.imgSrcHorizontalCommunity = '/omlet/static/imgs/OML_horizontal_' + metricsForWeek1['Community'][0]['OML Level'] + '.svg';
    $scope.imgSrcHorizontalChannelFeed = '/omlet/static/imgs/OML_horizontal_' + metricsForWeek1['Channel Feed'][0]['OML Level'] + '.svg';
    $scope.imgSrcHorizontalContent = '/omlet/static/imgs/OML_horizontal_' + metricsForWeek1['Content'][0]['OML Level'] + '.svg';
    $scope.imgSrcHorizontalPartnerships = '/omlet/static/imgs/OML_horizontal_' + metricsForWeek1['Partnerships'][0]['OML Level'] + '.svg';
    $scope.imgSrcHorizontalDevSuccess = '/omlet/static/imgs/OML_horizontal_' + metricsForWeek1['Dev Success'][0]['OML Level'] + '.svg';
    $scope.imgSrcHorizontalAPIInfra = '/omlet/static/imgs/OML_horizontal_' + metricsForWeek1['API Infra'][0]['OML Level'] + '.svg';
    $scope.showMetricsForTwitch();
    $scope.showTwoWeeksData();

    var state = $.bbq.getState();

    $scope.hasInscreased = function(str1, str2) {
      return eval(str1.substring(str1.indexOf('(') + 1, str1.indexOf('%'))) > eval(str2.substring(str2.indexOf('(') + 1, str2.indexOf('%')))
    }

    $scope.hasDecreased = function(str1, str2) {
      return eval(str1.substring(str1.indexOf('(') + 1, str1.indexOf('%'))) < eval(str2.substring(str2.indexOf('(') + 1, str2.indexOf('%')))
    }


  }]);
