angular.module('omlet.services', [])
.factory('OmletApi', ['$http', '$rootScope', function ($http, $rootScope) {
    var omletURL = 'https://localhost';
    var metricsURL = omletURL + '/kpi',
        loading = 'api:events:loading',
        success = 'api:events:success';
    return {
        fetch: function (filters) {
            $rootScope.$broadcast(loading);
            return $http.get(metricsURL, {
                params: filters
            }).success(function (json) {
                $rootScope.$broadcast(success, json);
            });
        },
        loading: function (cb) { $rootScope.$on(loading, cb); },
        success: function (cb) {
            $rootScope.$on(success, function (e, json) {
                cb(json);
            });
        }
    };
}]);
