angular.module('qml.controllers', [])

  .controller('InputController', ['$scope', 'QmlApi', function($scope, QmlApi) {

    // var COVERAGE_COMPARE_WINDOW = 3; // set this to number of days for which you want the qmlerage delta to apply
    var TABLE_HEADER_TEAMS_AND_REPOS = "Teams & Repos"
    var TABLE_HEADER_TEAMS_ONLY = "Teams"
    var INCREASING_TEXT = "Sorted at Team level";
    var DECREASING_TEXT = "Sorted at Team level";
    var REPOS_DISPLAYED_TEXT = "Hide All Repos";
    var REPOS_HIDDEN_TEXT = "Show All Repos";

    // coverage thresholds
    $scope.threshold_low = 50;
    $scope.threshold_high = 80;

    // images
    $scope.imgSrcBiblethump = '/qml/static/images/biblethump.png';
    $scope.imgSrcBleedpurple = '/qml/static/images/bleedpurple.png';

    var invertOrder = false;
    var today = new Date();
    // var compareDay = new Date();
    // compareDay.setDate(today.getDate() - COVERAGE_COMPARE_WINDOW);
    var date_today = today.getFullYear() + '-' + (today.getMonth() + 1) + '-' + today.getDate();
    // var date_compareDay = compareDay.getFullYear() + '-' + (compareDay.getMonth() + 1) + '-' + compareDay.getDate();
    // console.log("Showing code-coverage delta between " + date_compareDay + " and " + date_today);

    $scope.viewRepo = true;

    // initial page load
    var promise1 = QmlApi.fetchTeams();
    var promise2 = QmlApi.fetchRepos();
    var promise3;
    Promise.all([promise1, promise2]).then(function(values) {
      $.bbq.pushState('#kpi_id=4&ingest_date='+date_today, 2);
      var state = $.bbq.getState();
      promise3 = QmlApi.fetchCurrentData(state, invertOrder);
      $scope.label_sortOrder = INCREASING_TEXT;
      $scope.label_viewRepo = REPOS_DISPLAYED_TEXT;
      $scope.table_header_teams_and_repos = TABLE_HEADER_TEAMS_AND_REPOS;
    });

    // toggle the sort order for coverage data
    $scope.toggleSorting = function() {
      if (invertOrder) {
        invertOrder = false;
        $scope.label_sortOrder = INCREASING_TEXT;
      } else {
        invertOrder = true;
        $scope.label_sortOrder = DECREASING_TEXT;
      }
      QmlApi.displayData(invertOrder);
    }

    // toggle the visibility of Repos
    $scope.toggleRepos = function() {
      var index;
      if ($scope.viewRepo) {
        $scope.viewRepo = false;
        $scope.label_viewRepo = REPOS_HIDDEN_TEXT;
        $scope.table_header_teams_and_repos = TABLE_HEADER_TEAMS_ONLY;
        for (index in $scope.team_coverage_map_current) {
          $scope.team_coverage_map_current[index].ShowRepo = false;
        }
      } else {
        $scope.viewRepo = true;
        $scope.label_viewRepo = REPOS_DISPLAYED_TEXT;
        $scope.table_header_teams_and_repos = TABLE_HEADER_TEAMS_AND_REPOS;
        for (index in $scope.team_coverage_map_current) {
          $scope.team_coverage_map_current[index].ShowRepo = true;
        }
      }
      QmlApi.displayData(invertOrder);
    }

  }])
