# codecov_coverage.json

When [`reportCodeCoverage`](code-coverage.md/#reporting-code-coverage) runs it'll generate a `codecov_coverage.json` that you can artifact in your builds so that services like [RPS](https://git-aws.internal.justin.tv/dta/rockpaperscissors) can work with coverage data.

The JSON data is a response from the Codecov API.  When reportCodeCoverage() runs it asks the server for the coverage data that was reported for the build.  This data contains a lot of information, but if you're interested in just the coverage, then you'll mainly care about `commit.parent_totals` and `commit.totals`:

* **`commit.parent_totals`**  Code coverage for the ***previous*** commit.
* **`commit.totals`** = Code coverage for the ***current*** commit.

Example File: (Only showing commit data for sake of abbreviation)
```
{
  ...,
   "commit": {
     ...,
     "parent_totals": {
       "c": "18.42818",
       "b": 0,
       "d": 0,
       "f": 3,
       "C": 0,
       "h": 68,
       "M": 0,
       "m": 299,
       "n": 369,
       "p": 2,
       "s": 1,
       "diff": null,
       "N": 0
     },
     "totals": {
       "c": "18.42818",
       "b": 0,
       "d": 0,
       "f": 3,
       "C": 0,
       "h": 68,
       "M": 0,
       "m": 299,
       "n": 369,
       "p": 2,
       "s": 4,
       "diff": null,
       "N": 0
     }
   }
}
```

As you can see, these json objects are structured the same, but sadly their keys are rather cryptic.  Below is a description of the important keys:

| JSON Key | Description |
| -------- | ----------- |
| c | Actual coverage ratio *(Hits / (Hits + Partials + Misses) )* |
| h | Hits counted *(Code that was fully executed)* |
| m | Misses counted *(Code that wasn't executed)* |
| p | Partials counted *(Code that wasn't fully executed)* |
| f | Number of files counted |
| b | Branches counted |
| d | Methods counted |
| n | Lines counted |
| diff | Similarly structured object that has the difference between this and previous commit |

In addition there are some other keys, but be warned that they aren't well documented in the [Codecov docs](https://docs.codecov.io/v4.3.0/reference#totals):

| JSON Key | Description |
| -------- | ----------- |
| C | Complexity |
| M | Messages counted |
| N | Names counted |
| s | Session counted |

And for the heck of it, here's a full sample of a `codecov_coverage.json`:

```
{
  "owner": {
    "username": "qe",
    "integration_id": null,
    "name": "Quality Engineering",
    "service": "github_enterprise",
    "updatestamp": "2017-03-28 18:58:54.836753",
    "service_id": "744"
  },
  "repo": {
    "using_integration": null,
    "name": "twerk",
    "language": "go",
    "deleted": false,
    "activated": false,
    "private": false,
    "updatestamp": "2017-03-28 18:59:00.79122+00",
    "branch": "master",
    "active": true,
    "service_id": "4233",
    "image_token": "5M5qCGznEA"
  },
  "meta": {
    "status": 200
  },
  "commit": {
    "pullid": null,
    "archived": true,
    "version": 3,
    "parent": "bc5faf8e2c161b76b1d2004de2045ecbc9205a38",
    "author": {
      "username": "gribilly",
      "service_id": "639",
      "email": "gribilly@justin.tv",
      "service": "github_enterprise",
      "name": "Billy Grissom"
    },
    "deleted": null,
    "timestamp": "2017-03-23 00:01:00",
    "parent_totals": {
      "c": "18.42818",
      "b": 0,
      "d": 0,
      "f": 3,
      "C": 0,
      "h": 68,
      "M": 0,
      "m": 299,
      "n": 369,
      "p": 2,
      "s": 1,
      "diff": null,
      "N": 0
    },
    "state": "complete",
    "totals": {
      "c": "18.42818",
      "b": 0,
      "d": 0,
      "f": 3,
      "C": 0,
      "h": 68,
      "M": 0,
      "m": 299,
      "n": 369,
      "p": 2,
      "s": 5,
      "diff": null,
      "N": 0
    },
    "commitid": "258cf8edcaac78870764733d592b5318affa32c3",
    "notified": true,
    "ci_passed": true,
    "updatestamp": "2017-03-28 22:43:57.905544",
    "branch": "master",
    "report": "<Report files=3>",
    "message": "Triggering Jenkins build",
    "merged": false
  }
}
```
