# Table of Contents
* [What is Code Coverage?](#what-is-code-coverage)
* [Generating Code Coverage](#generating-code-coverage)
* [Viewing Code Coverage](#viewing-code-coverage)
    * [Setting up the Codecov Browser Extension](#setting-up-the-codecov-extension)
* [Reporting Code Coverage](#reporting-code-coverage)
* [Using Code Coverage](#using-code-coverage)
    * [Requiring Coverage in Pull Requests](#requiring-coverage-in-pull-requests)
* [Help](#help)

# What is Code Coverage?

Code coverage is a measurement used to express which lines of code were executed by a test suite. There are three primary terms used to describe each lines execute.

* **hit** indicates the source code was executed by tests.
* **partial** indicates the source code was not fully executed and there are remaining branches that are not executed by the test suite.
* **miss** indicates the source code was not executed by the test suite.
Coverage is the ratio of total hits / (total of hit + partial + miss). A code base that has 5 lines executed by tests out of 12 total lines will receive a coverage ratio of 41% (rounding down).

In layman's terms code coverage provides a visual measurement of what source code is being executed by a test suite. This information indicates to the software developer where they should write new tests in the effort to achieve higher coverage.

# Generating Code Coverage

* golang
```
go get github.com/axw/gocov/gocov
go get github.com/t-yuki/gocov-xml

gocov test ./... > coverage.json
gocov-xml < coverage.json > coverage.xml
```

# Reporting Code Coverage

Assuming that your builds are [already generating code-coverage reports](#generating-code-coverage), you can send said coverage-reports to our Codecov instance.  Doing so will integrate them into GitHub - thus providing some visibility for your reports and allowing you to do things such as use code coverage data to [restrict pull requests](#using-code-coverage).

To do this,
0.  make sure your Jenkins job is generating code-coverage report, by checking console logs or workspace of Jenkins job
1.  add [codecov user](https://git-aws.internal.justin.tv/codecov) to your org in GitHub
2.  navigate to [code-cov user-account on github](https://git-aws.internal.justin.tv/codecov) and make sure you see the activity that Codecov bot joined your org
3.  copy the code-coverage report file to `.manta` directory
4.  make sure that the [dependency on `git` env variables](#dependency-on-git-environment-variables) is in place
5.  add the following to the `publishers` block in your `jenkins.groovy`:

```
reportQuality(repo, dir)
```

Where `repo` is the name of your repo in GitHub (i.e. `'qa/smoca'`) and dir is the directory within your build that you want to scan for code coverage reports (use `'.'` to scan current working directory).  The `reportQuality()` function will scan that directory recursively for coverage reports.  It is able to auto-detect and handle reporting a number of different code coverage file-formats.

It will also archive the code coverage as a build artifact (as well as any discovered `test_report.xml` files) so that other services such as RPS can interface with them.

### Optional File Pattern Parameter

In some instances, you may need to also provide a third-argument called `filename` that specifies either a single filename to look for or a given pattern to match.  Example:
```
reportQuality('dta/rockapaperscissors', '.manta', '*.out')
```
This will scan the `.manta` directory for files ending in `*.out`.  Any of these files with code coverage data will be uploaded to Codecov for the `dta/rockpaperscissors` repo.

Again, I would only advise using this 3rd parameter if you're noticing that the function isn't picking up reports.  In most situations, it does pick them up a'ok.  In the event that you do need to use it though, here's what it recognizes:

```
"path/to/file"     only upload this single file
                      skips searching unless provided patterns below
"!*.bar"           ignore all files at pattern *.bar
"*.foo"            include all files at pattern *.foo
```

### Dependency on `GIT` environment variables

The command depends on various `GIT` environment variables being set before it runs.  You can check if your Jenkins job is already supplying these variables by looking at the `Environment Variables` for a previous build [(example)](https://jenkins.internal.justin.tv/job/qe-codecov-test/37/injectedEnvVars/):

![Jenkins Env Variables](images/coverage-env.png)

If your builds are not setting these variables ***(Jenkins doesn't by default)***, then you need to modify your builds to do so.  You can do this by adding the following to the `wrappers` section of your `Jenkins.groovy`:

```
wrappers {
  environmentVariables {
    env('GIT_BRANCH', '${GIT_BRANCH}')
    env('GIT_COMMIT', '${GIT_COMMIT}')
    env('GIT_URL', '${GIT_URL}')
  }
}
```

### Fixing Paths
When `reportQuality()` gathers reports, it will use the `.git` directory to line up the path provided in the reports with the file-structure of the repo.  In some cases (like when you don't have the `.git` directory), it may be necessary to provide some *"path fixes"*.  If these are defined, then `reportQuality()` will use these for mapping the path in a coverage report to the directory structure of a repo.

You can define these within a `codecov.yml` that you create in your repository.  [See the Codecov docs](https://docs.codecov.io/docs/fixing-paths) for more information on how to do this.

### The `codecov_coverage.json` Artifact
`reportQuality()` will also generate a [`codecov_coverage.json`](code-coverage-json.md).  This contains information about the code coverage of the build.  If multiple coverage files were reported, then this will also be an aggregate summary of those files.

# Viewing Code Coverage

We use [Codecov](https://codecov.internal.justin.tv) for tracking code coverage.  While our Codecov instance does have its own front-end, its recommended that you use the [Codecov Extension](https://docs.codecov.io/docs/browser-extension) to view code coverage. This Extension will overlay code coverage statics for a repository in the GitHub UI like so:

![Coverage in GitHub](images/codecov-github.png)

In addition, clicking coverage links displayed throughout the UI will take you to the appropriate pages in Codecov to provide a more detailed view.

### Setting up the Codecov Extension

- [Download the extension for your browser](https://docs.codecov.io/docs/browser-extension)
- Once installed, click `Options` to configure the extension.
- Set the Codecov Endpoint to: `https://codecov.internal.justin.tv`
- Set the Github Endpoint to: `git-aws.internal.justin.tv`
- Click `Save Changes`.
- Go to [https://codecov.internal.justin.tv](https://codecov.internal.justin.tv) and sign in.
- Go back to GitHub.

And that's it!  You should now be able to see code coverage for projects in GitHub.  Here's an [example link](https://git-aws.internal.justin.tv/qe/twerk/tree/1d7945d6131b69a11493e2c3bb096a75ea831043) to try.

###### A Note about the Codecov UI
> The Codecov UI is great about showing coverage details for specific files / commits, but from a high-level standpoint it can be confusing to navigate.  In particular, the UI doesn't seem to account for squashes or missing commits very well (i.e. they still appear in the UI).
>
> Therefore, I'd recommended always browsing projects for coverage in GitHub and using the Codecov UI just when linking to the specifics via GitHub.

# Using Code Coverage
Once you've setup your builds to start reporting coverage, you should start seeing coverage comments in new pull-requests.

![Coverage in Pull Requests](images/coverage-pull-request.png)

Also, [assuming you have th eextension installed](#viewing-code-coverage), you should start seeing statistics for subsequent commits in the GitHub UI.

It will also add comments to pull-requests showing the overall coverage for pull-requests.

Asides simply viewing these metrics within GitHub, it's also possible to integrate coverage into your workflow.  For example, you can configure Codecov to provide status checks for coverage like so:

![Coverage in GitHub commits](images/coverage-github-commits.png)

By default, these status checks are off.  You can enable these and configure how they're calculated by creating a `codecov.yml` file in the root of your repository.  **[See the Codecov Docs](https://codecov.readme.io/v1.0/docs/commit-status)** for more information on configuring this file.

Below, is a brief description of what these status checks are:

### codecov/project
This status measures overall project coverage and compares it against the base of the pull request or parent commit.

This means that the first commit's coverage % is what's used to determine success for subsequent commits.  I.e. if the first commit's coverage is `18%`, then subsequent commits will be marked as success as long as their coverage % is equal to or greater than `18%`.

> The first commit that reports code coverage, will often see this fail with a "No report found" error.  This is a bug in Codecov and is due to the base not having any coverage data for this commit to compare to.  Subsequent commits, however, will be fine since they'll now use this as a base.

### codecov/patch
This status **only** measures lines adjusted in the pull request or single commit if the commit is not in a pull request. This status provides an indication on how well the pull request is tested.

By default, these status checks are off for repositories.  You can control how these

### Requiring Coverage in Pull Requests

If you decide to use the statuses mentioned above, then you can configure your GitHub repository to require code coverage when performing pull-requests into particular branches.  To do this simply do the following:

- Navigate to the `Settings` page for your repo.
- In the left panel click `Branches`.
- Assuming you have a Protected Branch, select `Edit` (if you don't then make one)

Note that if you select `Require status checks to pass before merging` you can toggle whether or not the Codecov statuses are required to pass:

![Code Coverage Status for Merging](images/coverage-status.png)

If you do enable the statuses in Codecov, then these are *not* marked as `Required` in GitHub by default.

# Help
Slack #codecov
