#!/bin/bash

# This script will execute go test and generate code coverage for all of the packages in your repository.
# This is necessary due to a 'multi-package' issue when running go test and '--coverprofile'.
# See this issue for more info: https://github.com/golang/go/issues/6909
#
# Script takes in a single arg which is the directory you want to output your results in.
# Test results will be in /results within this directory, while coverage results will be in /coverage.
# 
# This script will also run `twerk` which is hosted on our internal debian server.
# See here for information on installing it: 
# https://twitchtv.atlassian.net/wiki/display/QE/Reporting+Test+Results#ReportingTestResults-Thetwerkcommand
#

set -e

function abspath() {
    # generate absolute path from relative path
    # $1     : relative filename
    # return : absolute path
    if [ -d "$1" ]; then
        # dir
        (cd "$1"; pwd)
    elif [ -f "$1" ]; then
        # file
        if [[ $1 == */* ]]; then
            echo "$(cd "${1%/*}"; pwd)/${1##*/}"
        else
            echo "$(pwd)/$1"
        fi
    fi
}

OUT=$(abspath $1)
if [ ! -d "$OUT" ]; then
  mkdir "$OUT"
fi

test_path=${OUT}/test_results
coverage_path=${test_path}/coverage
results_path=${test_path}/results

mkdir -p ${coverage_path}
mkdir -p ${results_path}

for pkg in $SRCDIRS; do
  echo "Testing and generating coverage for: ${pkg}"
  pkg_name=${pkg//\//_}
  coverage_filename=${coverage_path}/${pkg_name}.out
  report_filename=${results_path}/${pkg_name}.xml
  go test -race -coverprofile=${coverage_filename} ${pkg} -v | go-junit-report > ${report_filename}
  if [[ -f ${coverage_filename} ]]; then
    go tool cover -func=${coverage_filename}
  fi
done


# This is optional, but it will output test result files that jenkins can consume and RPS can pick up.
twerk get-tests ${test_path} --output ${OUT}
