# Table of Contents
* [Reporting Test Results](#reporting-test-results)
  * [The `twerk` command](#the-twerk-command)
* [Generating Test Results](#generating-test-results)

# Reporting Test Results

The Twitch Ecosystem looks for a single `test_report.xml` Jenkins build artifact.  Various services use this file to determine test result status of builds.

This file must be of the **JUnit** file format.  Most testing frameworks have support for generating reports in this format.  If your tests, generate multiple JUnit files, then you will need to aggregate these files into a single `test_report.xml`.


## The `twerk` command
QE has written a tool do this called `twerk` for aggregating multiple JUnit files.  If you're already generating a single file, then you don't need to use `twerk`.

### Installing `twerk`

twerk is written in Go.  You can install it via `go get`, but it's recommended that you use the `apt-get` route for your Jenkins builds:

```
apt-get install twerk
```

`twerk` is hosted on our internal apt-get server.  If you're using docker/manta, all of the DevTools created images should already have access to this server.  If not, then you may need to add some additional steps to ensure this tool can be called:

```
curl -s -XGET https://packages.internal.justin.tv/artifactory/api/gpg/key/public | apt-key add -
add-apt-repository -y  http://aptly.internal.justin.tv/internal/twitch
apt-get update && apt-get install -y twerk
```

### Using `twerk`

After your tests are done in your build, you should run `twerk get-tests` and pass it a list of JUnit files (or directories) generated by your tests:

```
twerk get-tests file1 file2 file3 dir1 dir2 ...
```

When providing a list of files, you may pass in a flag to each arg that indicates what type of tests a list of file represent.  For example:

```
twerk get-tests --e2e file1 --e2e file2 --int file3 ...
```
This flag will set the type of the test suites as E2E for flie1 and fli2, while file3 will be `INTEGRATION`.  If you don't set a flag, then the type of the test suites will be set to UNIT.

Once twerk is done running, it'll generate a `test_report.xml` in the working directory.

> **Note**
>
> **`twerk` always returns an error code of 0** (even if it encounters an internal error when generating the archive file). This is to prevent it from failing builds in the event that it has its own quirks.

# Generating Test Results

Depending on the language and test-framework that you're using, getting your results into the `JUnit` format may vary.  Below are tips on how to convert results for a couple of commonly used testing frameworks here at Twitch.

## Go Tests
If you're using go test then you can pipe the verbose output of your test result to `go-junit-report`.  This will then generate a JUnit file at a path of your choosing.  Steps for setting this up are as follows:

```
go get -u github.com/jstemmer/go-junit-report   # Place this in your setup steps.
go test -v | go-junit-report > test_report.xml  # Pipe results into the tool
```

### Handling Code Coverage in Go
Generally you can use the `-coverprofile` arg  with `go test` to get coverage reports for your Go based projects.  That being said, Go has some issues if your project has [multi-package dependencies](https://github.com/golang/go/issues/6909).  The workaround for now, is to use a wrapper script to get past this and generate coverage.  [See the sample script here.](run_go_test.sh)

## JavaScript Tests
If you're using karma for deploying your JavaScript tests, then you can the JUnit Reporter package.  This can easily be installed via npm or yarn and then added to your Karma Config.  From there, you can configure that path at which you want to output tests.

## Ruby Tests
If you're using rspec, then I recommend you use: https://github.com/sj26/rspec_junit_formatter
If you're using something else, then take a look at: https://github.com/ci-reporter/ci_reporter
