# ElasticSearch Index Retention

This application will delete ElasticSearch Indexes for Logging after a configurable number of days

## Environment Variables

| Name | Default | Description |
| ---- | -------- | ---------- |
| ES_ENDPOINT | REQUIRED | The elastic search endpoint to query and delete indexes against
| RETENTION_DAYS | 30 | The number of days to store indexes until they are deleted
| LOCAL | false | Provide true if you're running this locally on your computer
| DRY_RUN | false | Skips making the actual delete request to ElasticSearch (for testing)

You may also need to provide [AWS CLI Environment variables](https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-envvars.html)
if you're running locally

## Running within Lambda
Ensure the Lambda Execution Role contains IAM Permissions to make esHttpGet and esHTTPDelete requests to the ElasticSearch Endpoint

Handler: `main`

## Running Locally
Provide environment variable `LOCAL=true` so it will not run in a Lambda context.

Accessing the ElasticSearch Instance requires IAM Permissions to make esHttpGet and esHTTPDelete

Provide your AWS Profile as an environment variable
```
AWS_PROFILE=reichsta-eb-logging DRY_RUN=true LOCAL=true go run main.go
```
