variable "bucket_name" {
  default = "es-index-lifecycle-artifacts"
}

# Add an S3 Bucket for the Artifacts
# Allow Jenkins to put objects into the bucket for uploading artifacts
resource "aws_s3_bucket" "artifacts" {
  bucket = "${var.bucket_name}"

  tags = {
    Repository = "qe/es_index_lifecycle"
  }
}
##########################################################################
# Create Roles & Policy to allow Jenkins to upload objects to the bucket #
##########################################################################
resource "aws_iam_role" "artifacts_jenkins" {
  name = "${var.bucket_name}-jenkins-upload"
  assume_role_policy = <<POLICY
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Principal": {
        "AWS": [
          "arn:aws:iam::043714768218:role/jenkins-prod-master",
          "arn:aws:iam::043714768218:role/jenkins-prod-slave"
        ]
      },
      "Action": "sts:AssumeRole"
    }
  ]
}
POLICY
}

resource "aws_iam_policy" "s3_upload_policy" {
  name        = "${var.bucket_name}-s3-upload"
  description = "Allows for uploading objects to the ${var.bucket_name} bucket"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": [
        "s3:PutObject",
        "s3:PutObjectAcl"
      ],
      "Effect": "Allow",
      "Resource": "arn:aws:s3:::${var.bucket_name}/*"
    }
  ]
}
EOF
}

resource "aws_iam_role_policy_attachment" "s3_upload_policy_attach" {
  role       = "${aws_iam_role.artifacts_jenkins.name}"
  policy_arn = "${aws_iam_policy.s3_upload_policy.arn}"
}
