[![Go Report Card](https://goreportcard.internal.justin.tv/badge/code.justin.tv/qe/goreportcard)](https://goreportcard.internal.justin.tv/report/code.justin.tv/qe/goreportcard)

# Go Report Card

A web application that generates a report on the quality of an open source go project. It uses several measures, including `gofmt`, `go vet`, `go lint` and `gocyclo`. To get a report on your own project, try using the hosted version of this code running at [goreportcard](https://goreportcard.internal.justin.tv).

GoReportCard uses gometalinter to do the checks. They use https://github.com/alecthomas/gometalinter/blob/master/linters.go to call each linter.

### Installation

Assuming you already have a recent version of Go installed, pull down the code with `go get`:

```
go get code.justin.tv/qe/goreportcard
```

Go into the source directory and pull down the project dependencies:

```
cd $GOPATH/src/code.justin.tv/qe/goreportcard
make install
```

Before you can continue, you'll need to add some Env vars about oauth to Guardian and
tokens for git access. Reach out to #quality-engineering if you are interested.

Now run

```
make start-dev
```

and you should see

```
Running on 127.0.0.1:8000...
```

Navigate to that URL in your browser and check that you can see the front page.

When running the site in a production environment, instead of `make start-dev`, run:

```
make start
```

### Deploy process 

We use Clean deploy. The process is to deploy to staging first, compare scores between prod and staging for a major product like edge/visage, and then deploy to prod.

### License

The code is licensed under the permissive Apache v2.0 licence. This means you can do what you like with the software, as long as you include the required notices. [Read this](https://tldrlegal.com/license/apache-license-2.0-(apache-2.0)) for a summary.

