package check

// DeadCode is the check for the deadcode command
type DeadCode struct {
	Dir       string
	Filenames []string
}

// Name returns the name of the display name of the command
func (g DeadCode) Name() string {
	return "deadcode"
}

// Weight returns the weight this check has in the overall average
func (g DeadCode) Weight() float64 {
	return 1.0
}

// Percentage returns the percentage of .go files that pass go vet
func (g DeadCode) Percentage() (float64, []FileSummary, error) {
	return GoTool(g.Dir, g.Filenames, []string{"gometalinter", "--deadline=180s", "--disable-all", "--enable=deadcode"})
}

// Description returns the description of go lint
func (g DeadCode) Description() string {
	return `Looks for unused declarations`
}
