package check

// Gas is the check for the GAS Go security-oriented static code analyser
type Gas struct {
	Dir       string
	Filenames []string
}

// Name returns the name of the display name of the command
func (g Gas) Name() string { return "gas" }

// Weight returns the weight this check has in the overall average
func (g Gas) Weight() float64 { return 0 }

// Percentage returns the percentage of .go files that pass gas
func (g Gas) Percentage() (float64, []FileSummary, error) {
	return GoTool(g.Dir, g.Filenames, []string{"gometalinter", "--deadline=180s", "--disable-all", "--enable=gas"})
}

// Description returns the description of gas
func (Gas) Description() string {
	return `<code>gas</code> examines Go source code and reports potential security issues with varying levels of confidence.`
}
