package check

// GoFmt is the check for the go fmt command
type GoFmt struct {
	Dir       string
	Filenames []string
}

// Name returns the name of the display name of the command
func (g GoFmt) Name() string {
	return "gofmt"
}

// Weight returns the weight this check has in the overall average
func (g GoFmt) Weight() float64 {
	return 1.0
}

// Percentage returns the percentage of .go files that pass gofmt
func (g GoFmt) Percentage() (float64, []FileSummary, error) {
	// By Default, gometalinter runs gofmt -s, which not everyone agrees with. Here we override the message and the cmd
	return GoTool(g.Dir, g.Filenames,
		[]string{
			"gometalinter",
			"--deadline=180s",
			"--disable-all",
			"--linter='gofmt:gofmt -l:'",
			"--message-overrides'gofmt:file is not gofmted'",
			"--enable=gofmt",
		})
	// return GoFmtNative(g.Dir, g.Filenames)
}

// Description returns the description of gofmt
func (g GoFmt) Description() string {
	return `Gofmt formats Go programs.`
}
