package check

// GoImports checks for missing or unreferenced imports
type GoImports struct {
	Dir       string
	Filenames []string
}

// Name returns the name of the display name of the command
func (g GoImports) Name() string {
	return "goimports"
}

// Weight returns the weight this check has in the overall average
func (g GoImports) Weight() float64 {
	return .30
}

// Percentage returns the percentage of .go files that pass GoImports
func (g GoImports) Percentage() (float64, []FileSummary, error) {
	return GoTool(g.Dir, g.Filenames, []string{"gometalinter", "--deadline=180s", "--disable-all", "--enable=goimports"})
}

// Description returns the description of GoImports
func (g GoImports) Description() string {
	return `GoImports makes sure you have no unused imports and all needed imports. We run <code>goimports</code> on your code`
}
