package check

// Megacheck checks for missing or unreferenced imports
type Megacheck struct {
	Dir       string
	Filenames []string
}

// Name returns the name of the display name of the command
func (g Megacheck) Name() string {
	return "megacheck"
}

// Weight returns the weight this check has in the overall average
func (g Megacheck) Weight() float64 {
	return 1.0
}

// Percentage returns the percentage of .go files that pass Megacheck
func (g Megacheck) Percentage() (float64, []FileSummary, error) {
	return GoTool(g.Dir, g.Filenames, []string{"gometalinter", "--deadline=180s", "--disable-all", "--enable=Megacheck"})
}

// Description returns the description of Megacheck
func (g Megacheck) Description() string {
	return `Megacheck checks statics, code simplification, and unused code`
}
