package check

// StructCheck is the check for the structcheck command
type StructCheck struct {
	Dir       string
	Filenames []string
}

// Name returns the name of the display name of the command
func (g StructCheck) Name() string {
	return "structcheck"
}

// Weight returns the weight this check has in the overall average
func (g StructCheck) Weight() float64 {
	return 1.0
}

// Percentage returns the percentage of .go files that pass go vet
func (g StructCheck) Percentage() (float64, []FileSummary, error) {
	return GoTool(g.Dir, g.Filenames, []string{"gometalinter", "--deadline=180s", "--disable-all", "--enable=structcheck"})
}

// Description returns the description of go lint
func (g StructCheck) Description() string {
	return `Find unused struct fields`
}
