package check

// VarCheck is the check for the varcheck command
type VarCheck struct {
	Dir       string
	Filenames []string
}

// Name returns the name of the display name of the command
func (g VarCheck) Name() string {
	return "varcheck"
}

// Weight returns the weight this check has in the overall average
func (g VarCheck) Weight() float64 {
	return 1.0
}

// Percentage returns the percentage of .go files that pass go vet
func (g VarCheck) Percentage() (float64, []FileSummary, error) {
	return GoTool(g.Dir, g.Filenames, []string{"gometalinter", "--deadline=180s", "--disable-all", "--enable=varcheck"})
}

// Description returns the description of go lint
func (g VarCheck) Description() string {
	return `VarCheck checks for unused global variables and constants`
}
