package handlers

import (
	"encoding/json"
	"fmt"
	"html/template"
	"log"
	"net/http"

	db2 "code.justin.tv/qe/goreportcard/db"
	"github.com/boltdb/bolt"
)

// HomeHandler handles the homepage
func HomeHandler(w http.ResponseWriter, r *http.Request) {
	if r.URL.Path[1:] == "" {
		db, err := db2.Connect()
		if err != nil {
			log.Println("Failed to open bolt database: ", err)
			return
		}
		defer func() {
			err := db.Close()
			if err != nil {
				log.Printf("failed to close bolt db %v ", err)
			}
		}()

		recent := &[]recentItem{}
		err = db.View(func(tx *bolt.Tx) error {
			rb := tx.Bucket([]byte(MetaBucket))
			if rb == nil {
				return fmt.Errorf("meta bucket not found")
			}
			b := rb.Get([]byte("recent"))
			if b == nil {
				b, err = json.Marshal([]recentItem{})
				if err != nil {
					return err
				}
			}
			return json.Unmarshal(b, recent)
		})

		var recentRepos = make([]string, len(*recent))
		var j = len(*recent) - 1
		for _, r := range *recent {
			recentRepos[j] = r.Repo
			j--
		}

		t := template.Must(template.New("home.html").Delims("[[", "]]").ParseFiles("templates/home.html", "templates/footer.html"))
		err = t.Execute(w, map[string]interface{}{
			"Recent":               recentRepos,
			"google_analytics_key": googleAnalyticsKey,
		})
		if err != nil {
			http.Error(w, "Could not render home page", http.StatusInternalServerError)
		}

		return
	}

	errorHandler(w, r, http.StatusNotFound)
}
