package handlers

import (
	"encoding/json"
	"fmt"
	"log"
	"net/http"
	"strconv"
)

// ScoreHandler returns just a score, for other reporting apps
func ScoreHandler(w http.ResponseWriter, r *http.Request, repo string, dev bool) {
	forceRefresh := false
	forceRefreshStrs, ok := r.URL.Query()["forceRefresh"]
	if ok && len(forceRefreshStrs) == 1 {
		var err error
		forceRefresh, err = strconv.ParseBool(forceRefreshStrs[0])
		if err != nil {
			log.Println("Received forceRefresh value that could not be turned to bool", forceRefreshStrs)
			http.Error(w, fmt.Sprintf("Value provided for forceRefresh not parsable as boolean %v", forceRefreshStrs),
				http.StatusInternalServerError)
			return
		}
	}
	resp, err := newChecksResp(repo, forceRefresh)
	if err != nil {
		log.Println("Could not get repo score for ", repo, err.Error())
		http.Error(w, err.Error(), http.StatusInternalServerError)
		return
	}

	b, err := json.Marshal(resp)
	if err != nil {
		log.Println("JSON marshal error:", err)
		http.Error(w, fmt.Sprintf("Json marshal error %s", err.Error()), http.StatusInternalServerError)
		return
	}
	_, err = w.Write(b)
	if err != nil {
		log.Println("Could not render scores response", err.Error())
		http.Error(w, err.Error(), http.StatusInternalServerError)
	}
}
