package main

import (
	"encoding/json"
	"fmt"
	"log"

	db2 "code.justin.tv/qe/goreportcard/db"
	"github.com/boltdb/bolt"
)

const (
	repoBucket string = "repos"
)

type checksResp struct {
	Repo    string  `json:"repo"`
	Average float64 `json:"average"`
}

func main() {
	db, err := db2.Connect()
	if err != nil {
		log.Fatal(err)
	}
	defer db.Close()
	err = db.Update(func(tx *bolt.Tx) error {
		rb := tx.Bucket([]byte(repoBucket))
		if rb == nil {
			return fmt.Errorf("repo bucket not found")
		}
		rb.ForEach(func(k, v []byte) error {
			resp := checksResp{}
			err := json.Unmarshal(v, &resp)
			if err != nil {
				return err
			}
			log.Printf("%s - %.2f", resp.Repo, resp.Average*100)
			return nil
		})

		return nil
	})
	if err != nil {
		log.Fatal(err)
	}
}
