# GuardiaN

[![GuardiaN](http://static-cdn.jtvnw.net/jtv_user_pictures/panel-36797764-image-42a9fd739816972f-320.png)](https://youtu.be/jj8V1W8DP_o)

An [OAuth2](http://tools.ietf.org/html/rfc6749) authorization service that
also integrates with and serves LDAP resources (users & groups) here at Twitch.

Please see the [WIKI](https://wiki.twitch.com/display/SSE/GuardiaN%3A+OAuth2+for+Internal+Employee+Auth)

## Local Development Environment Setup:

* Go to [Isengard](http://isengard) and obtain admin credentials for `twitch-sse-prod`
  account.
* Install [`henshin`](https://git-aws.internal.justin.tv/geoffcha/henshin)
* Install the `sandstorm` cli: `go get
  code.justin.tv/systems/sandstorm/cmd/sandstorm`
* `eval $(henshin env)` in the root of the repo to set your environment
  variables to the testing user's AWS credentials.

## API

*Contents*:

* [Integration](docs/integration.md)
* [Authentication](https://git-aws.internal.justin.tv/systems/guardian#authentication)
* [OAuth](https://git-aws.internal.justin.tv/systems/guardian#oauth)
* [Clients API](https://git-aws.internal.justin.tv/systems/guardian#clients-api)
* [Identity(LDAP) API](https://git-aws.internal.justin.tv/systems/guardian#resource-api)

### Authentication

#### Token

OAuth tokens can be passed via Authorization http header as bearer token or as
basic auth with the token as the password.

#### LDAP User Credentials

User credentials can be provided via Authorization http header as basic auth.

### OAuth

* `GET` `/oauth2/authorize`:

Check `client_id` and `client_secret` passed in via Authorization http header
as basic auth. Redirect to the url in the `redirect_uri` query param with the
same `state` query param in the request. Also pass temporary code in `code`
query param. See
[spec](http://tools.ietf.org/html/rfc6749#section-4.1.2).

* `POST` `/oauth2/token`:

Check `client_id` and `client_secret` passed in via Authorization http header
as basic auth.  Check `code` form value and expiry. Create refresh/access token
and return. Return redirect to URI from `redirect_uri` form value, which must
match the configured callback uri for the client. Token should be base-16
representation of randomly generated `[]byte` of len 20.

Request:

| name | type | description |
| ---- | ---- | ----------- |
| `grant_type` | `string` | REQUIRED: oauth2 grant type. One of `authorization_code`, `password`, `client_credentials`, `refresh_token` |
| `code` | `string` | Temporary authorization code issued by the authorize endpoint. REQUIRED when using temporary auth code. |
| `redirect_uri` | `string` | URI to redirect client to. Should match what's configured for client. |
| `refresh_token` | `string` | Refresh token used to get a new access token. REQUIRED when using `refresh_token` grant type. |

Response:

| name | type | description |
| ---- | ---- | ----------- |
| `access_token` | `string` | oauth2 access token |
| `refresh_token` | `string` | oauth2 refresh token (optional) |
| `token_type` | `string` | token type, should always be `bearer` |
| `expires_in` | `int` | time in seconds until expiry date |
| `scope` | `string` | comma delimited list of scopes for this token. Should be null since since scope should be the same as the configured client scopes |

* `GET` `/oauth2/check_token`:

Check token passed in request via
[Authorization](https://git-aws.internal.justin.tv/systems/guardian#authentication)
http header.

Response:

```json
{
  "token": {
    "access_token": "<token>",
    "token_type": "Bearer",
    "expiry": "0001-01-01T00:00:00Z"
  },
  "user": {
    "cn": "<ldap cn>",
    "uid": "<ldap uid>",
    "groups": [
      ..."<ldap groups>"...
    ]
  }
}
```

### Clients API

Manage clients using HTTP API. Create, read, update or delete clients.

* `GET` `/clients/`:

Returns list of configured clients. See `/<prefix>/client/:client_id` endpoint
for data.

* `GET` `/clients/:client_id`:

Response:

| name | type | description |
| ---- | ---- | ----------- |
| `client_id` | `string` | oauth2 client id |
| `version` | `string` | uuid representing version of client configuration |
| `redirect_url` | `string` | oauth2 redirect url |
| `callback_url` | `string` | oauth2 callback url |
| `description` | `string` | optional notes about client |
| `name` | `string` | name of client |
| `[]string` | `scopes` | scopes available to client |

* `POST` `/clients/`:

Create a client.

Request:

| name | type | description |
| ---- | ---- | ----------- |
| `redirect_url` | `string` | oauth2 redirect url |
| `callback_url` | `string` | oauth2 callback url |
| `description` | `string` | optional notes about client |
| `name` | `string` | name of client |
| `[]string` | `scopes` | scopes available to client |

Response:

| name | type | description |
| ---- | ---- | ----------- |
| `client_id` | `string` | oauth2 client id |
| `version` | `string` | uuid representing version of client configuration |
| `redirect_url` | `string` | oauth2 redirect url |
| `callback_url` | `string` | oauth2 callback url |
| `description` | `string` | optional notes about client |
| `name` | `string` | name of client |
| `[]string` | `scopes` | scopes available to client |

* `PUT` `/clients/:client_id`:

Update a client.

You only need to provide the attributes that need updating. Changing scopes
will generate a new version of the client, and all previously issued tokens
will be revoked.

Request:

| name | type | description |
| ---- | ---- | ----------- |
| `redirect_url` | `string` | oauth2 redirect url |
| `callback_url` | `string` | oauth2 callback url |
| `description` | `string` | optional notes about client |
| `name` | `string` | name of client |
| `[]string` | `scopes` | scopes available to client |

Response:

| name | type | description |
| ---- | ---- | ----------- |
| `client_id` | `string` | oauth2 client id |
| `version` | `string` | uuid representing version of client configuration |
| `redirect_url` | `string` | oauth2 redirect url |
| `callback_url` | `string` | oauth2 callback url |
| `description` | `string` | optional notes about client |
| `name` | `string` | name of client |
| `[]string` | `scopes` | scopes available to client |

* `DELETE` `/clients/:client_id`:

Deletes a client.

### Resource API

Read-only API for basic group and user data from LDAP.

* `GET` `/users/`:

Returns list of users. See `/<prefix>/user/:cn` endpoint for data.

* `GET` `/users/:uid`:

Returns information about requested user.

Response:

| name  | type | description |
| ----- | ---- | ----------- |
| `uid` | `string` | uid |
| `cn` | `string` | ldap user cn |
| `gid_number` | `int64` | gidNumber |
| `home_dir` | `string` | homeDirectory (optional) |
| `uid_number` | `int64` | uidNumber (optional) |
| `email` | `string` | email |
| `ssh_pubkeys` | `[]string` | ssh pubkeys (optional) |
| `groups` | `[]string` | list of `cn` of groups user belongs to |

* `GET` `/groups/`:

Returns list of groups. See `/<prefix>/group/:cn` endpoint for data.

* `GET` `/groups/:cn`:

Response:

| name | type | description |
| ---- | ---- | ----------- |
| `gid` | `int64` | gidNumber |
| `cn` | `string` | cn of group |
| `description` | `string` | description of group |
| `members` | `[]string` | `uid`s of members in the group  |

## Scopes

| scope | description |
| ----- | ----------- |
| `ldap_group` | Grants access to groups user belongs to. |
| `ldap_user` | Grants access to user information. |

## DynamoDB schema

* `clients` table:

| type        | name        | description |
| ----------- | ----------- | ----------- |
| hash key    | `id` | oauth2 client id |
| `string`    | `version`   | uuid representing version of client configuration |
| `string`    | `secret_hash` | oauth2 client secret (sha-2) (update requires new id) |
| `string`    | `callback_url` | oauth2 callback url |
| `string`    | `description`  | optional notes about client |
| `string`    | `name` | name of client |
| `string`    | `homepage` | link to homepage of application (optional) |
| `string`    | `description` | text description of application (optional) |
| `[]string`   | `scopes` | scopes available to client |

* `authorizations` table:

| type      | name         | description |
| --------- | ------------ | ----------- |
| hash key | `token_hash` | access/refresh token (sha-2). auth codes are
stored in plaintext (not hashed). |
| `string` | `client_id` | oauth2 client id |
| `int64`  | `valid_from` | time before which token is invalid in seconds since epoch |
| `int32`  | `expires_in` | lifetime of token in seconds since `valid_from` |
| `string` | `version`    | uuid representing version of client configuration (validate against clients table) |
| `string` | `type`       | `refresh` or `access` or `auth` |
| `string` | `user` | ldap CN of user that generated this authorization. REQUIRED if created by user. If generated by client credentials, then this field is omitted. |
| `string` | `callback_url` | (optional) redirect from request |
| `[]string` | `scopes`    | scopes available to client |
| `string` | `state` | state provided in request |
| `string` | `name` | "name" attached to token |

## Configuration

GuardiaN expects a `config.yaml` file in one of the following locations:

* `/etc/twitch/guardian/config.yaml`
* `$HOME/.config/twitch/guardian/config.yaml`

The contents of the file are as follows:

```yaml
ldap:
  use_tls: true
  address: ldap.internal.justin.tv
  port: 636
  bind_user: user
  bind_password: password
db:
  clients_table: clients
  authorizations_table: authorizations
  aws_region: us-west-2
  aws_endpoint: http://localhost:9000
```

## Related projects

* [RangelReale/osin](https://github.com/RangelReale/osin) library for oauth2
  authorization services
* [go-ldap/ldap](https://github.com/go-ldap/ldap)
