# Guardian Integration Guide

## OAuth

Guardian implements the OAuth2 protocol meaning that any third-party library
that handles OAuth2 should be able to make use of Guardian.

### Creating A New Client

A new OAuth2 client can be created via the [dashboard](https://guardian.prod.us-west2.twitch.tv/guardian).

### Via Go

For API Services, we've written a middleware that makes authenticating Guardian
Oauth2 tokens simple. See [asiimov](https://git-aws.internal.justin.tv/systems/guardian/blob/master/middleware/asiimov.go).

## LDAP Services

If you need a way to query LDAP groups and users for your own services, that is
also feasible.

Currently Guardian supports the following public endpoints accessible from
`https://guardian.prod.us-west2.twitch.tv`:

* /resource/users
* /resource/groups

### Via Go

Probably the easiest way to use this package is via [JSC](https://godoc.org/github.com/derekdowling/go-json-spec-handler/client):

```go
doc, resp, err := jsc.List("https://guardian.prod.us-west2.twitch.tv/resource", "users")
```
