package storage

import (
	"testing"

	. "github.com/smartystreets/goconvey/convey"
)

func TestAuthStorage(t *testing.T) {
	Convey("Auth code Storage Tests", t, func() {
		storage := CreateTestDB()

		client, err := TestClient(storage)
		if client != nil {
			defer storage.DeleteClientByID(adminUser, client.GetID())
		}
		So(client, ShouldNotBeNil)
		So(err, ShouldBeNil)
		saveClientErr := storage.SaveClient(client)
		So(saveClientErr, ShouldBeNil)

		authData, createAuthDataErr := CreateTestAuthorizeData(client)
		So(createAuthDataErr, ShouldBeNil)
		So(authData, ShouldNotBeNil)
		saveErr := storage.SaveAuthorize(authData)
		So(saveErr, ShouldBeNil)

		Convey("delete token", func() {
			removeAuthErr := storage.RemoveAuthorize(authData.Code)
			So(removeAuthErr, ShouldBeNil)

			loadedAuth, loadErr := storage.LoadAuthorize(authData.Code)
			So(loadErr, ShouldBeNil)
			So(loadedAuth, ShouldBeNil)
		})
	})
}
