package storage

import (
	"code.justin.tv/systems/guardian/guardian/tokens"
	"code.justin.tv/systems/guardian/osin"
)

// DefaultTokenGenerator is the package level token generator
var DefaultTokenGenerator = TokenGenerator{tokens.DefaultTokenGenerator}

// TokenGenerator wraps a *(tokens).TokenGenerator to satisfy osin
type TokenGenerator struct {
	*tokens.TokenGenerator
}

// GenerateAuthorizeToken generates a token for temporary authorization
func (t TokenGenerator) GenerateAuthorizeToken(data *osin.AuthorizeData) (ret string, err error) {
	ret, _, err = t.TokenGenerator.GenerateSecret()
	return
}

// GenerateAccessToken generates an access token
func (t TokenGenerator) GenerateAccessToken(data *osin.AccessData, generaterefresh bool) (accesstoken string, refreshtoken string, err error) {
	accesstoken, _, err = t.TokenGenerator.GenerateSecret()
	if err != nil {
		return
	}

	if generaterefresh {
		refreshtoken, _, err = t.TokenGenerator.GenerateSecret()
		if err != nil {
			return
		}
	}

	data.Version = data.Client.GetVersion()
	return
}
