job {
    name 'systems-guardian-build'
    using 'TEMPLATE-autobuild'
    wrappers {
        credentialsBinding {
            string 'AWS_ACCESS_KEY_ID', 'sse_test_aws_access_key_id'
            string 'AWS_SECRET_ACCESS_KEY', 'sse_test_aws_secret_access_key'
            string 'dta_tools_deploy', 'dta_tools_deploy'
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
        }
    }

    scm {
        git {
            remote {
                github 'systems/guardian', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
        }
    }

    steps {
        shell 'rm -rf .manta/'
        shell 'manta -v -e AWS_ACCESS_KEY_ID -e AWS_SECRET_ACCESS_KEY -f .manta.json'
        saveDeployArtifact 'systems/guardian', '.manta'
    }

    publishers {
        archiveJunit('.manta/test_report.xml') {
            allowEmptyResults()
            retainLongStdout()
        }
        reportQuality('systems/guardian', '.manta')
    }
}

job {
    name "systems-guardian-deploy"
    using 'TEMPLATE-deploy'
    steps {
        shell 'courier deploy --repo systems/guardian --dir /opt/twitch/guardian'
    }
}
