// http://stackoverflow.com/a/133997
function post(path, params, method) {
    method = method || "post"; // Set method to post by default if not specified.

    // The rest of this code assumes you are not using a library.
    // It can be made less wordy if you use one.
    var form = document.createElement("form");
    form.setAttribute("method", method);
    form.setAttribute("action", path);

    for(var key in params) {
        if(params.hasOwnProperty(key)) {
            var hiddenField = document.createElement("input");
            hiddenField.setAttribute("type", "hidden");
            hiddenField.setAttribute("name", key);
            hiddenField.setAttribute("value", params[key]);

            form.appendChild(hiddenField);
         }
    }

    document.body.appendChild(form);
    form.submit();
}

$(document).ready(function() {

    // submitRedirect overrides the default form submission action and instead
    // performs a custom redirect with the collected LDAP Credentials via Basic
    // Auth Headers
    var submitRedirect = function(event) {
        event.preventDefault();

        var username = $('input[name="username"]').val();
        var password = $('input[name="password"]').val();

        // build our forwarding url
        var forward = 'https://' + url('hostname');
        var port = url('port');
        if (typeof port !== 'undefined') {
            forward += ":" + port;
        }
        forward += '/oauth2/authorize?';

        // parse and pass current url query with the redirect url
        var query = url('query');
        if (typeof query !== 'undefined') {
            forward += query;
        }

        var params = {
            username: username,
            password: password,
        };
        post(forward, params);
    };

    $('form').submit(submitRedirect);
});
