resource "aws_dynamodb_table" "authorizations" {
  name           = "authorizations-${var.env}"
  read_capacity  = 20
  write_capacity = 20

  hash_key = "token_hash"

  attribute {
    name = "token_hash"
    type = "S"
  }

  attribute {
    name = "client_id"
    type = "S"
  }

  global_secondary_index {
    name            = "ClientIDIndex"
    hash_key        = "client_id"
    projection_type = "ALL"
    read_capacity   = 20
    write_capacity  = 20
  }
}

data "aws_iam_policy_document" "authorizations" {
  statement {
    actions = [
      "dynamodb:DeleteItem",
      "dynamodb:GetItem",
      "dynamodb:PutItem",
    ]
    resources = [
      "${aws_dynamodb_table.authorizations.arn}"
    ]
  }
}

resource "aws_iam_policy" "authorizations" {
  name        = "guardian-service-authorizations-${var.env}"
  path        = "/"
  description = "guardian service policy to access authorizations table"
  policy      = "${data.aws_iam_policy_document.authorizations.json}"
}

resource "aws_iam_policy_attachment" "authorizations" {
  name       = "guardian-service-authorizations-attachment-${var.env}"
  roles      = [
    "${aws_iam_role.service.name}",
  ]
  policy_arn = "${aws_iam_policy.authorizations.arn}"
}
