resource "aws_dynamodb_table" "clients" {
  name = "clients-${var.env}"

  read_capacity  = 20
  write_capacity = 20
  hash_key       = "id"

  attribute {
    name = "id"
    type = "S"
  }
}

data "aws_iam_policy_document" "clients" {
  statement {
    actions = [
      "dynamodb:DeleteItem",
      "dynamodb:GetItem",
      "dynamodb:PutItem",
      "dynamodb:Scan",
    ]
    resources = [
      "${aws_dynamodb_table.clients.arn}"
    ]
  }
}

resource "aws_iam_policy" "clients" {
  name        = "guardian-service-clients-${var.env}"
  path        = "/"
  description = "guardian service policy to access clients table"
  policy      = "${data.aws_iam_policy_document.clients.json}"
}

resource "aws_iam_policy_attachment" "clients" {
  name       = "guardian-service-clients-attachment-${var.env}"
  roles      = [
    "${aws_iam_role.service.name}",
  ]
  policy_arn = "${aws_iam_policy.clients.arn}"
}
