resource "aws_elb" "elb" {
  name            = "guardian-${var.env}"
  subnets         = ["${values(var.subnet_ids)}"]
  security_groups = ["${var.vpc_security_group}"]
  internal        = true

  listener {
    instance_port      = 8181
    instance_protocol  = "http"
    lb_port            = 443
    lb_protocol        = "https"
    ssl_certificate_id = "${var.acm_certificate_arn}"
  }

  health_check {
    healthy_threshold   = 2
    unhealthy_threshold = 2
    timeout             = 3
    target              = "HTTP:8181/health"
    interval            = 30
  }

  instances                 = ["${aws_instance.guardian-apiserver.*.id}"]
  cross_zone_load_balancing = true
}

output "elb_dns_name" {
  value = "${aws_elb.elb.dns_name}"
}

output "elb_name" {
  value = "${aws_elb.elb.name}"
}
