resource "aws_iam_role" "service" {
  name               = "guardian-service-${var.env}"
  assume_role_policy = "${data.aws_iam_policy_document.service-assume-role.json}"
}

data "aws_iam_policy_document" "service-assume-role" {
  statement {
    actions = [
      "sts:AssumeRole",
    ]
    principals {
      type        = "Service"
      identifiers = ["ec2.amazonaws.com"]
    }
    principals {
      type        = "AWS"
      identifiers = [
        "arn:aws:iam::516651178292:user/sse-test-user"
      ]
    }
  }
}

data "aws_iam_policy_document" "sandstorm-assume-role" {
  statement {
    actions = [
      "sts:AssumeRole",
    ]
    resources = [
      "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/guardian-${var.env}"
    ]
  }
}

data "aws_iam_policy_document" "malachai-assume-role" {
  statement {
    actions = [
      "sts:AssumeRole",
    ]
    resources = [
      "arn:aws:iam::180116294062:role/malachai/*"
    ]
  }
}

resource "aws_iam_policy" "sandstorm-assume-role" {
  name        = "guardian-sandstorm-assume-role-${var.env}"
  path        = "/"
  description = "grant access to assume sandstorm role"
  policy      = "${data.aws_iam_policy_document.sandstorm-assume-role.json}"
}

resource "aws_iam_policy" "malachai-assume-role" {
  name        = "guardian-malachai-assume-role-${var.env}"
  path        = "/"
  description = "grant access to assume malachai role"
  policy      = "${data.aws_iam_policy_document.malachai-assume-role.json}"
}

resource "aws_iam_policy_attachment" "sandstorm-assume-role" {
  name  = "guardian-sandstorm-assume-role-attachment-${var.env}"
  roles = [
    "${aws_iam_role.service.name}"
  ]
  policy_arn = "${aws_iam_policy.sandstorm-assume-role.arn}"
}

resource "aws_iam_policy_attachment" "malachai-assume-role" {
  name  = "guardian-malachai-assume-role-attachment-${var.env}"
  roles = [
    "${aws_iam_role.service.name}"
  ]
  policy_arn = "${aws_iam_policy.malachai-assume-role.arn}"
}
