variable "region" {
  default = "us-west-2"
}

variable "aws_profile" {
  default = "twitch-sse-prod"
}

variable "env" {}
variable "admin_role_arn" {}
variable "subnet_ids" {
  type    = "map"
  default = {}
}
variable "vpc_security_group" {}
variable "instance_count" {
  default = "3"
}
variable "instance_type" {
  default = "m3.medium"
}
variable "hostname_env" {}
variable "twitch_aws_r53_zone_id" {
  default = "ZRG00SM48517Z"
}
variable "acm_certificate_arn" {}

variable "baseami" {
  default = "ami-29363d50"
}

provider "aws" {
  region  = "${var.region}"
  profile = "${var.aws_profile}"

  assume_role {
    role_arn = "${var.admin_role_arn}"
  }
}

provider "aws" {
  region  = "us-west-2"
  profile = "twitch-aws"
  alias   = "twitch-aws"
}
