module "production" {
  source         = "./modules"
  env            = "production"
  instance_count = "3"
  aws_profile    = "${var.sse_prod_profile}"
  admin_role_arn = "${var.guardian_prod_admin_role}"

  subnet_ids = {
    us-west-2a = "subnet-518cdf18"
    us-west-2b = "subnet-aec6fec9"
    us-west-2c = "subnet-c05f879b"
  }

  vpc_security_group  = "sg-64d0db1f"
  hostname_env        = "prod"

  # aws --profile twitch-guardian-prod acm request-certificate --domain-name 'guardian-production.prod.us-west2.justin.tv' --subject-alternative-names 'guardian.prod.us-west2.twitch.tv' 'guardian.internal.justin.tv' --domain-validation-options 'DomainName=guardian-production.prod.us-west2.justin.tv,ValidationDomain=justin.tv' 'DomainName=guardian.prod.us-west2.twitch.tv,ValidationDomain=twitch.tv' 'DomainName=guardian.internal.justin.tv,ValidationDomain=justin.tv'
  acm_certificate_arn = "arn:aws:acm:us-west-2:922727123873:certificate/e37769a0-9d46-4321-8fbf-6066b4358b8a"
}

resource "aws_cloudwatch_metric_alarm" "guardian_elb" {
  provider            = "aws.prod"
  alarm_name          = "guardian-elb-healthy-backends"
  comparison_operator = "LessThanThreshold"
  evaluation_periods  = "5"
  metric_name         = "HealthyHostCount"
  namespace           = "AWS/ELB"
  period              = "60"
  statistic           = "Average"
  threshold           = "1"
  alarm_description   = "triggered when there are fewer than 1 healthy backend stormwatch instances attached to this elb"
  alarm_actions       = ["${aws_sns_topic.guardian_elb.arn}"]
  ok_actions          = ["${aws_sns_topic.guardian_elb.arn}"]

  dimensions {
    LoadBalancerName = "${module.production.elb_name}"
  }
}

resource "aws_sns_topic" "guardian_elb" {
  provider = "aws.prod"
  name     = "guardian-prod-elb-check"
}

resource "aws_sns_topic_subscription" "guardian_elb" {
  provider               = "aws.prod"
  topic_arn              = "${aws_sns_topic.guardian_elb.arn}"
  protocol               = "https"
  endpoint               = "https://events.pagerduty.com/integration/b7544d72fd934f78b4ff5e7d32493759/enqueue"
  endpoint_auto_confirms = true
}

resource "aws_route53_record" "elb-compat-dns-record-prod" {
  provider = "aws.twitch-aws"
  zone_id = "${var.twitch_r53_zone_id}"
  name = "guardian.prod.us-west2.twitch.tv"
  type = "CNAME"
  ttl = "300"
  records = ["${module.production.elb_dns_name}"]
}
