package agent

import (
	"os/user"
	"runtime"
	"testing"

	. "github.com/smartystreets/goconvey/convey"
)

func TestUserInfo(t *testing.T) {

	Convey("Test User Logic", t, func() {

		user, err := user.Current()
		So(err, ShouldBeNil)

		Convey("->getUserID()", func() {

			uid, err := getUserID(user.Username)
			So(err, ShouldBeNil)
			So(uid, ShouldEqual, DefaultUserID)
		})

		Convey("->getGroupId()", func() {

			group := "root"

			// allows us to test locally
			if runtime.GOOS == "darwin" {
				group = "staff"
			}

			gid, err := getGroupID(group)
			So(err, ShouldBeNil)
			So(gid, ShouldEqual, DefaultGroupID)

			group = "notreal"
			gid, err = getGroupID(group)
			So(err, ShouldNotBeNil)
		})

		Convey("->setDefaultIDs", func() {
			err := setDefaultIDs()
			So(err, ShouldBeNil)

			So(DefaultUserID, ShouldEqual, RootID)
			So(DefaultGroupID, ShouldEqual, RootID)
		})
	})
}
