# Sandstorm Agent Package Building

This folder contains the scripts and resources necesarry to build 9 or more
packages for sandstorm-agent. These packages are 1 each for Precise, Xenial,
and RedHat. Multiplied by each environment we're building for. The default
environments are `staging`, `production` and `canary`.

## Process

The [/jenkins.groovy](../../../jenkins.groovy) file in this repo runs
[/jenkins/build.sh](../../../jenkins/build.sh). This shell script then runs
the [../build_agent.sh](../build_agent.sh) in the parent folder. Then the
build_agent script runs manta using the [../.manta.json](../.manta.json) file,
also in the parent folder. Manta sets up a place for the artifacts, builds the
Go app and then runs the [build_pkg.sh](build_pkg.sh) script in this folder to
make the packages. Finally, this build_pkg script sources the `build-environment.sh`
scripts in [production/](production) and [staging/](staging). Complicated?

These final build scripts make the packages using `fpm`, and Jenkins stores them
in S3 for later upload to Artifactory. Uploading is performed with
[Skadi](https://clean-deploy.internal.justin.tv/#/home).

## Production & Canary Environments

The production environment is built using the script located at
[production/build-production.sh](production/build-production.sh). The script
builds 6 packages. The production and canary packages are identical.

## Staging Environments

The `staging` environment (and others) can be used to test packaging changes.
These alternative environments use their own build script. The path is
`environment/build-environment.sh`. Example, if the environment name is staging:
[staging/build-staging.sh](staging/build-staging.sh)

Each environment should create 3 packages. Only staging has a job configured in
[/jenkins.groovy](../../../jenkins.groovy) to uplaod to artifactory, so if
another alternate environment build is created the packages will need to be
handled accordingly. Either add another upload job or download from S3 and test
them manually.

## Links

Add links to all the jenkins jobs and skadi builds.
Add links to puppet manifests (puppet, transcode-puppet, others?) These all "deploy"...
