#!/bin/bash
# This script sits between monit and systemctl/systemd. The purpose is simple:
# - Log any attempt at using monit to control sandstorm-agent.
# Why? So we can tell people to stop using monit to control sandstorm-agent.

PATH=/bin:/usr/bin
CMD=${1}
LOG="grand-central-syslog.prod.us-west2.justin.tv"
MSG="Monit sandstorm-agent command issued: ${CMD}"

if [[ "$CMD" = "stop" || "$CMD" = "start" || "$CMD" = "restart" ]]; then
  systemctl ${CMD} sandstorm-agent
fi
# TCP port 514
logger -p local3.warn -t sandstorm-monit --port 514 --tcp --server "${LOG}" "${MSG}"
