NAME
-----
`sandstorm` is a command-line tool for storing and retrieving secrets
from Sandstorm DynamoDB tables.

```
> sandstorm help
NAME:
   sandstorm - command-line tool for interacting with Sandstorm secrets

USAGE:
   sandstorm [global options] command [command options] [arguments...]

VERSION:
   v1.0.3 (git )

COMMANDS:
     get            Fetches a secret from the Sandstorm table and outputs the plaintext secret to stdout.
     get-versions   Fetches versions of a secret from the Sandstorm table and prints each timestamp to stdout.
     get-encrypted  Fetches a secret from the Sandstorm and prints it out to stdout.
     put            Deprecated use update/create instead. Reads a plaintext from standard input and stores it encrypted in the Sandstorm table
     revert         Revert a secret to a previous version and don't create a new entry in the audit table. See get-versions for version ids.
     update         Updates an existing secret in sandstorm
     create         Create a new secret in sandstorm
     copy           Copies an encrypted secret from Sandstorm to another secret name
     help, h        Shows a list of commands or help for one command

GLOBAL OPTIONS:
   --help, -h     show help
   --version, -v  print the version
```

ENVIRONMENT
-----------
`SANDSTORM_TABLE_NAME` - Name of sandstorm table (default: "sandstorm-production")

`SANDSTORM_ROLE_ARN` - Role ARN for cross-account access

`SANDSTORM_MASTER_KEY` - Use KMS master key KEY for encryption (default: "alias/sandstorm-production")


