#!/bin/sh
set -eo pipefail

rm -rf .manta/ build/
mkdir -p build

sh ./scripts/lint.sh

manta -update -v -e AWS_ACCESS_KEY_ID -e AWS_SECRET_ACCESS_KEY -f .manta.json
manta -v -e AWS_ACCESS_KEY_ID -e AWS_SECRET_ACCESS_KEY -f cmd/sandstorm-apiserver/.manta.json
manta -v -e AWS_ACCESS_KEY_ID -e AWS_SECRET_ACCESS_KEY -f cmd/sandstorm-cli/sandstorm-cmd-manta-deb.json
manta -v -e AWS_ACCESS_KEY_ID -e AWS_SECRET_ACCESS_KEY -f .manta.python.json
./cmd/sandstorm-agent/build_agent.sh
sh ./jenkins/build-inventory.sh
cp -rf cmd/scripts .manta/dest/

# need to access jenkins scripts during deployment
cp -r jenkins build

# TODO: only temporary to get the jenkins build working
# everything should just be output to build
cp -r .manta/dest/* build
cp .manta/*.log build || true
