package mocks

import mock "github.com/stretchr/testify/mock"

// Enveloper is an autogenerated mock type for the Enveloper type
type Enveloper struct {
	mock.Mock
}

// Open provides a mock function with given fields: key, ciphertext, ctxt
func (_m *Enveloper) Open(key []byte, ciphertext []byte, ctxt map[string]string) ([]byte, error) {
	ret := _m.Called(key, ciphertext, ctxt)

	var r0 []byte
	if rf, ok := ret.Get(0).(func([]byte, []byte, map[string]string) []byte); ok {
		r0 = rf(key, ciphertext, ctxt)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]byte)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func([]byte, []byte, map[string]string) error); ok {
		r1 = rf(key, ciphertext, ctxt)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Seal provides a mock function with given fields: keyID, ctxt, plaintext
func (_m *Enveloper) Seal(keyID string, ctxt map[string]string, plaintext []byte) ([]byte, []byte, string, error) {
	ret := _m.Called(keyID, ctxt, plaintext)

	var r0 []byte
	if rf, ok := ret.Get(0).(func(string, map[string]string, []byte) []byte); ok {
		r0 = rf(keyID, ctxt, plaintext)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]byte)
		}
	}

	var r1 []byte
	if rf, ok := ret.Get(1).(func(string, map[string]string, []byte) []byte); ok {
		r1 = rf(keyID, ctxt, plaintext)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).([]byte)
		}
	}

	var r2 string
	if rf, ok := ret.Get(2).(func(string, map[string]string, []byte) string); ok {
		r2 = rf(keyID, ctxt, plaintext)
	} else {
		r2 = ret.Get(2).(string)
	}

	var r3 error
	if rf, ok := ret.Get(3).(func(string, map[string]string, []byte) error); ok {
		r3 = rf(keyID, ctxt, plaintext)
	} else {
		r3 = ret.Error(3)
	}

	return r0, r1, r2, r3
}
