module "production" {
  source             = "./modules"
  env                = "production"
  instance_count     = "3"
  aws_profile        = "twitch-sse-prod"
  admin_role_arn     = "arn:aws:iam::584671007337:role/Admin"
  s2s_roles_wildcard = "arn:aws:iam::180116294062:role/malachai/*"

  subnet_ids = {
    us-west-2a = "subnet-b81e53f1"
    us-west-2b = "subnet-0de9c36a"
    us-west-2c = "subnet-9563b7ce"
  }

  vpc_security_group  = "sg-489db033"
  hostname_env        = "prod"
  acm_certificate_arn = "arn:aws:acm:us-west-2:584671007337:certificate/5e7fca01-8535-40d9-a13d-e165362789cb"

  # wildcard.prod.us-west2.twitch.tv
  compat_acm_certificate_arn = "arn:aws:acm:us-west-2:584671007337:certificate/8d8c0a47-c070-4527-b90e-b7d293cd731d"
}

resource "aws_cloudwatch_metric_alarm" "sandstorm_elb" {
  provider            = "aws.prod"
  alarm_name          = "sandstorm-elb-healthy-backends"
  comparison_operator = "LessThanThreshold"
  evaluation_periods  = "5"
  metric_name         = "HealthyHostCount"
  namespace           = "AWS/ELB"
  period              = "60"
  statistic           = "Average"
  threshold           = "1"
  alarm_description   = "triggered when there are fewer than 1 healthy backend sandstorm instances attached to this elb"
  alarm_actions       = ["${aws_sns_topic.sandstorm_elb.arn}"]
  ok_actions          = ["${aws_sns_topic.sandstorm_elb.arn}"]

  dimensions {
    LoadBalancerName = "${module.production.elb_name}"
  }
}

resource "aws_sns_topic" "sandstorm_elb" {
  provider = "aws.prod"
  name     = "sandstorm-prod-elb-check"
}

resource "aws_sns_topic_subscription" "sandstorm_elb" {
  provider               = "aws.prod"
  topic_arn              = "${aws_sns_topic.sandstorm_elb.arn}"
  protocol               = "https"
  endpoint               = "https://events.pagerduty.com/integration/b7544d72fd934f78b4ff5e7d32493759/enqueue"
  endpoint_auto_confirms = true
}

provider "aws" {
  region  = "us-west-2"
  profile = "twitch-sse-prod"
  alias   = "prod"

  assume_role {
    role_arn = "arn:aws:iam::584671007337:role/Admin"
  }
}

provider "aws" {
  region  = "us-west-2"
  profile = "twitch-aws"
  alias   = "twitch-aws"
}

resource "aws_route53_record" "elb-compat-dns-record-prod" {
  provider = "aws.twitch-aws"
  zone_id  = "Z127RUWUPOFGHX"
  name     = "sandstorm.prod.us-west2.twitch.tv"
  type     = "CNAME"
  ttl      = "300"
  records  = ["${module.production.elb_compat_dns_name}"]
}
