module "testing" {
  source = "./common"
  env    = "testing"

  aws_profile    = "twitch-sandstorm-infra-aws"
  aws_account_id = "734326455073"

  secrets_sns_arn                = "arn:aws:sns:us-west-2:734326455073:sandstorm-testing"
  secrets_sqs_arn                = "arn:aws:sqs:us-west-2:734326455073:sandstorm*"
  secrets_kms_arn                = "arn:aws:kms:us-west-2:734326455073:key/ec100850-4cca-43c8-88c4-320a3bf98600"
  secrets_table_arn              = "arn:aws:dynamodb:us-west-2:734326455073:table/sandstorm-testing"
  inventory_execute_api_role_arn = "arn:aws:iam::516651178292:role/inventory-gateway-execute-api-invoke-testing"
}

module "staging" {
  source = "./common"
  env    = "staging"

  aws_profile    = "twitch-sandstorm-infra-aws"
  aws_account_id = "734326455073"

  secrets_sns_arn                = "arn:aws:sns:us-west-2:734326455073:sandstorm-staging"
  secrets_sqs_arn                = "arn:aws:sqs:us-west-2:734326455073:sandstorm*"
  secrets_kms_arn                = "arn:aws:kms:us-west-2:734326455073:key/7e35716a-dc00-47e8-a596-cc990555f7b5"
  secrets_table_arn              = "arn:aws:dynamodb:us-west-2:734326455073:table/sandstorm-staging"
  inventory_execute_api_role_arn = "arn:aws:iam::516651178292:role/inventory-gateway-execute-api-invoke-staging"
}

module "production" {
  source = "./common"
  env    = "production"

  aws_profile    = "twitch-sandstorm-infra-aws"
  aws_account_id = "734326455073"

  secrets_sns_arn                = "arn:aws:sns:us-west-2:734326455073:sandstorm-production"
  secrets_sqs_arn                = "arn:aws:sqs:us-west-2:734326455073:sandstorm*"
  secrets_kms_arn                = "arn:aws:kms:us-west-2:734326455073:key/60e0f97f-eeca-4834-b146-7ac9fb20fd74"
  secrets_table_arn              = "arn:aws:dynamodb:us-west-2:734326455073:table/sandstorm-production"
  inventory_execute_api_role_arn = "arn:aws:iam::854594403332:role/inventory-gateway-execute-api-invoke-production"
}

module "dev" {
  source                                = "./dev"
  aws_profile                           = "twitch-sse-dev"
  aws_account_id                        = "516651178292"
  sandstorm_apiserver_role_arn          = "arn:aws:iam::734326455073:role/sandstorm-apiserver-testing"
  sandstorm_agent_role_arn              = "arn:aws:iam::734326455073:role/sandstorm-agent-testing-rw"
  sandstorm_python_testing_role_arn     = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/sandstorm-python-dev"
  inventory_admin_testing_role_arn      = "arn:aws:iam::516651178292:role/inventory-admin-testing"
  inventory_stormwatch_testing_role_arn = "arn:aws:iam::516651178292:role/inventory-stormwatch-service-testing"
  s2s_role_arn                          = "arn:aws:iam::180116294062:role/malachai/*"
  inventory_deployment_role_arn         = "arn:aws:iam::516651178292:role/inventory-lambda-artifact-deploy"
}
